#!/usr/bin/perl -T 
# nazwa pliku: choose-graph.pl 
 
use strict; 
use warnings; 
use CGI; 
use PNGgraph::linespoints; 
use PNGgraph::pie; 
use PNGgraph::bars; 
 
# Utworz nowa instancje klasy CGI 
my $query = new CGI; 
 
# ------------------------------------------------------------ 
# Utworz wykres 
# ------------------------------------------------------------
 
# Jakiego rodzaju wykres wybral uzytkownik? 
my $graph; 
my $graph_type = $query->param("type") || ""; 
 
if ($graph_type eq "linespoints") 
  { 
    $graph = new PNGgraph::linespoints(500,500); 
  } 
elsif ($graph_type eq "bars") 
  { 
    $graph = new PNGgraph::bars(500,500); 
  } 
elsif ($graph_type eq "pie") 
  { 
    $graph = new PNGgraph::pie(500,500); 
  } 
else 
  { 
    print $query->header; 
    print $query->dump; 
    die "I don't know what a '$graph_type'! chart is: $! "; 
} 
 
# Zmien kazdy z siedmiu parametrow na wartosci, o domyslnej  
# wartosci 0 
my @points = map { $query->param("data-$_") or 0}  (1 .. 7); 
 
# Zdefiniuj legende i dane 
my @data = ([(1 .. 7)], 
            \@points); 
 
my $image = $graph->plot(\@data); 
 
# ------------------------------------------------------------ 
# Teraz wyslij wynik do przegladarki uzytkownika 
# ------------------------------------------------------------ 
 
# Wyslij odpowiedni nagolwek sygnalizujacy obraz PNG, 
# ktory nie powinien byc nigdy przechowywany w pamieci podrecznej 
print $query->header(-type => "image/png", 
                    -length => length($image)); 
 
# Przygotuj wykres i wyslij go do przegladarki uzytkownika  
print $image; 
