#!/usr/bin/perl -T 
# nazwa pliku: write-and-redirect.pl 
 
use strict; 
use warnings; 
use CGI; 
use Fcntl qw(:flock); 
 
# Wlacz autooczyszczanie 
$| = 1; 
 
# Utworz instancje klasy CGI 
my $query = new CGI; 
 
# Pobierz elementy formularza 
my $name = $query->param("name") || ""; 
my $email = $query->param("email") || ""; 
 
my $logfile = "/tmp/write-log"; 
 
# Zachowaj elementy formularza na dysku 
if (open LOG, ">>$logfile") 
{ 
    # Zablokuj uchwyt pliku 
    my $status = flock LOG, LOCK_EX; 
    die "Cannot lock '$logfile': $! " unless $status; 
 
    # Zapisz $name, $email oddzielone znakiem tab 
    print LOG "$name\t$email\n"; 
 
    # Odblokuj uchwyt pliku 
    flock LOG, LOCK_UN; 
 
    # Zamknij uchwyt LOG 
    close LOG; 
 
    # Wyslij uzytkownika do strony podziekowania  
    print $query->redirect("/thanks.html"); 
} 
 
# Jesli nie mozna otworzyc pliku, wyswietl komunikat o bledzie  
else 
{ 
    print $query->header; 
    print $query->start_html(-title => "Error!"); 
    print "<p>Could not open logfile for writing: '$!'</p>"; 
    print $query->end_html; 
} 
