#!/usr/bin/perl 
# nazwa pliku: insert-category.pl 
 
use strict; 
use warnings; 
use DBI; 
 
# Polacz sie z baza danych. 
my $username = 'reuven'; 
my $password = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $username, $password, 
                       { 'AutoCommit' => 1, 'RaiseError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
# Pobierz od uzytkownika nazwe nowej kategorii 
print "Enter the new category name: "; 
my $category_name = <>; 
chomp $category_name; 
 
# Nazwa kategorii musi zawierac przynajmniej jeden znak 
if ($category_name !~ /\w/) 
{ 
    print "Category names must contain at least one "; 
    print "alphanumeric character.  Exiting.\n"; 
} 
 
# Jesli nazwa kategorii jest OK, sprobuj ja wstawic 
else 
{ 
    # Usun niepotrzebne spacje 
    $category_name =~ s/^\s+//g; 
    $category_name =~ s/\s+$//g; 
 
    # Wylacz AutoCommit na czas jednej transakcji. Pozostanie on wylaczony 
    # do czasu wywolania metody $dbh->commit() lub $dbh->rollback(). 
 
    $dbh->begin_work(); 
 
    # ------------------------------------------------------------ 
    # Czy taka nazwa kategorii juz jest w bazie danych? 
    # Jesli tak, wycofaj transakcje, poinformuj uzytkownika o problemie 
    # i zakoncz prace. 
 
    # Utworz zapytanie 
    my $select_sql = "SELECT COUNT(category_id) "; 
    $select_sql .= "FROM Categories where category_name = ?"; 
 
    # Przygotuj instrukcje 
    my $sth = $dbh->prepare($select_sql); 
 
    # Wykonaj instrukcje 
    $sth->execute($category_name); 
 
    # Pobierz wynik 
    my ($category_already_exists) = $sth->fetchrow_array; 
 
    # Zakoncz to zapytanie 
    $sth->finish; 
 
    if ($category_already_exists) 
    { 
        print "The category '$category_name' already exists in the "; 
        print "database.\nPlease try again with a different name.\n"; 
 
        # Transakcja wycofana. 
        $dbh->rollback(); 
    } 
 
    else 
    { 
        # Przygotuj zapytanie INSERT  
        my $sql = "INSERT INTO Categories (category_name) VALUES (?) "; 
 
        # Przygotuj instrukcje 
        my $successfully_inserted = $dbh->do($sql, undef, $category_name); 
 
        if ($successfully_inserted) 
        { 
            print "Successfully inserted the category '$category_name'.\n"; 
            $dbh->commit(); 
        } 
        else 
        { 
            print "Error inserting: '$DBI::errstr'.\n"; 
            $dbh->rollback(); 
        } 
    } 
} 
 
# Zakoncz polaczenie z baza danych 
$dbh->disconnect; 
