#!/usr/bin/perl 
# nazwa pliku: insert-book.pl 
 
use strict; 
use warnings; 
use DBI; 
use Term::Complete; 
 
print "Welcome to the 'insert book' program.\n\n"; 
 
# Polacz sie z baza danych. 
my $username = 'reuven'; 
my $password = ''; 
my $dbh = DBI->connect("DBI:Pg:dbname=coreperl", $username, $password, 
                       { 
                        'AutoCommit' => 1, 'RaiseError' => 1}) || 
    die "Error connecting: '$DBI::errstr' "; 
 
# Zdefiniuj pare czesto uzywanych zmiennych  
my ($sql, $sth); 
 
# ------------------------------------------------------------ 
# Zacznij nowa transakcje, ktora zakonczy przywolanie $dbh->commit() 
# lub $dbh->rollback(). 
$dbh->begin_work(); 
 
# ------------------------------------------------------------ 
# Pobierz autorow i uczyn ich kluczami tablicy asocjacyjnej  
my %authors = (); 
 
$sql  = "SELECT author_name, author_id "; 
$sql .= "FROM Authors"; 
 
# Przygotuj instrukcje 
$sth = $dbh->prepare($sql); 
 
# Wykonaj instrukcje 
$sth->execute; 
 
while (my $rowref = $sth->fetchrow_arrayref) 
{ 
    my ($author_name, $author_id) = @{$rowref}; 
    $authors{$author_name} = $author_id; 
} 
 
# ------------------------------------------------------------ 
# Pobierz wydawcow i uczyn ich kluczami tablicy asocjacyjnej  
my %publishers = (); 
 
$sql  = "SELECT publisher_name, publisher_id "; 
$sql .= "FROM Publishers"; 
 
# Przygotuj instrukcje 
$sth = $dbh->prepare($sql); 
 
# Wykonaj instrukcje 
$sth->execute; 
 
while (my $rowref = $sth->fetchrow_arrayref) 
{ 
    my ($publisher_name, $publisher_id) = @{$rowref}; 
    $publishers{$publisher_name} = $publisher_id; 
} 
 
# ------------------------------------------------------------ 
# Pobierz informacje od uzytkownika 
my $isbn = get_info("ISBN"); 
my $title = get_info("title"); 
 
# Pobierz wielu autorow 
my @authors; 
while (my $author = get_info("author (or <enter> when done)", keys %authors)) 
{ 
    last unless $author; 
    push @authors, $author; 
} 
 
my $publisher = get_info("publisher", keys %publishers); 
my $pages = get_info("page count"); 
my $pub_date = get_info("publication date (YYYY-MM-DD)"); 
my $us_dollar_price = get_info("price in dollars"); 
 
# ------------------------------------------------------------ 
# Wstaw do bazy nowa ksiazke 
$sql  = "INSERT INTO Books "; 
$sql .= " (isbn, title, publisher_id, num_pages, "; 
$sql .= "  pub_date, us_dollar_price) "; 
$sql .= "VALUES (?, ?, ?, ?, ?, ?) "; 
 
$sth = $dbh->prepare($sql); 
 
$sth->execute($isbn, $title, $publishers{$publisher}, $pages, 
              $pub_date, $us_dollar_price); 
 
my $new_book_oid = $sth->{pg_oid_status}; 
 
$sth->finish(); 
 
# ------------------------------------------------------------ 
# Uzyj identyfikatora OID nowej ksiazki do pobrania book_id 
 
$sql  = "SELECT book_id "; 
$sql .= "FROM Books "; 
$sql .= "WHERE oid = ?"; 
 
# Przygotuj instrukcje 
$sth = $dbh->prepare($sql); 
 
# Wykonaj instrukcje 
$sth->execute($new_book_oid); 
 
# Pobierz book_id z wiersza o identyfikatorze OID 
my ($new_book_id) = $sth->fetchrow_array; 
 
$sth->finish(); 
 
# ------------------------------------------------------------ 
# Wstaw powiazanie ksiazki z autorem  
$sql  = "INSERT INTO BookAuthors (book_id, author_id) VALUES (?, ?) "; 
 
$sth = $dbh->prepare($sql); 
 
foreach my $author (@authors) 
{ 
    $sth->execute($new_book_id, $authors{$author}); 
    print "Done.\n"; 
} 
 
# Instrukcja zakonczona 
$sth->finish(); 
 
# Jesli wszystko poszlo dobrze, zatwierdzamy transakcje  
$dbh->commit(); 
 
# Zamykamy polaczenie z baza danych 
$dbh->disconnect(); 
 
# ------------------------------------------------------------ 
# Procedura pobierajaca informacje od uzytkownika 
sub get_info 
{ 
    my $question = shift; 
    my @completions = @_; 
    my %completions_hash = map {($_, 1)} @completions; 
 
    my $input = ""; 
 
    # Uzywamy Term::Complete, jesli trzeba uzupelnic dane 
    if (@completions) 
    { 
        $input =  
            Complete("Enter the book's $question: ", keys %completions_hash); 
    } 
 
    # Jesli nie ma takiej potrzeby, rozpoczynamy standardowo  
    else 
    { 
        print "Enter the book's $question: ";  
        $input = <>;            # Pobierz dane od uzytkownika 
        chomp $input;           # Usun z konca znak nowego wiersza 
 
        $input =~ s/^\s+//g;    # Usun spacje z poczatku 
        $input =~ s/\s+$//g;    # Usun spacje z konca 
    } 
 
    return $input; 
} 
