#!/usr/bin/perl 
# nazwa pliku: socket-server.pl 
 
use strict; 
use warnings; 
use IO::Socket; 
 
# Utworz gniazdo serwera 
my $socket = IO::Socket::INET->new(Proto => "tcp", 
                                   LocalPort => 5555, 
                                   Listen => SOMAXCONN, 
                                   Reuse => 1); 
 
print STDERR "Starting server...\n"; 
 
# Przyjmij nadchodzace polaczenie 
while (my $client = $socket->accept())  
{ 
    # Odczytaj jeden wiersz wyslany przez klienta 
    my $buffer = <$client>; 
 
    print STDERR qq|Received: "$buffer"\n|; 
 
    # Pobierz aktualna date 
    my $date = localtime time; 
 
    # Wyslij informacje do klienta 
    print $client "Hello from the server on $date!\n"; 
 
    close $client; 
} 
 
print STDERR "Shutting down server...\n"; 
