#!/usr/bin/perl 
# nazwa pliku: list-links.pl 
 
use strict; 
use warnings; 
use LWP::UserAgent; 
use HTTP::Request; 
use HTML::LinkExtor; 
 
# Pobierz adres URL z wiersza polecen 
my $url = $ARGV[0] 
    or die "No URL entered!";  
 
# Utworz zadanie 
my $request = new HTTP::Request("GET", $url); 
 
# Utworz agenta uzytkownika 
my $ua = new LWP::UserAgent; 
 
# Wyslij zadanie do serwera i pobierz odpowiedz 
my $response = $ua->request($request); 
 
# Przygotuj parser 
my $parser = new HTML::LinkExtor(\&parse_link); 
 
# Przeanalizuj zawartosc odpowiedzi 
$parser->parse($response->content); 
 
sub parse_link 
{ 
    # Pobierz informacje o laczu 
    my ($type, %attributes) = @_; 
 
    # Ignoruj wszystko poza hiperlaczami (znacznikami "kotwic") 
    return unless (lc $type eq "a"); 
 
    # Wyswietlaj na biezaco 
    print "\t", $attributes{href}, "\n"; 
} 
