#!/usr/bin/perl 
# nazwa pliku: anonymous-pipe.pl 
 
use strict; 
use warnings; 
 
# Utworz potoki 
pipe(READONLY, WRITEONLY); 
 
# Rozwidlenie! 
my $pid = fork(); 
 
# Upewnij sie, ze rozwidlenie dziala 
die "Cannot fork: $! " unless (defined $pid); 
 
# Oto potomek, ktory pisze do procesu nadrzednego 
if ($pid == 0) 
{ 
    # Zamknij uchwyt pliku tylko do odczytu 
    close READONLY; 
 
    # Wyslij wiadomosc do procesu nadrzednego 
    print WRITEONLY "Hello from the child, PID $$!\n"; 
 
    # Zawsze zamykaj uchwyt pliku 
    close WRITEONLY or die "Error closing: $! "; 
 
    exit; 
} 
 
# Oto proces nadrzedny odczytujacy wiadomosc od potomka 
else 
{ 
    # Zamknij uchwyt pliku tylko do zapisu 
    close WRITEONLY; 
 
    # Pobierz wiadomosc od procesu potomnego 
    print while (<READONLY>); 
 
    # Zawsze zamykaj uchwyt pliku 
    close READONLY or die "Error closing: $! "; 
 
    exit; 
} 
