#!/usr/bin/perl -w
# plik: mchat_server.pl
# Serwer pogawedki z rozsylaniem grupowym

use strict;
use IO::Socket::Multicast;
use ChatObjects::ChatCodes;
use ChatObjects::MChannel;
use ChatObjects::MComm;
use constant DEBUG => 0;

# tablica rozdzielcza
my %dispatch = (
 LOGOFF()=> 'logout',
 JOIN_REQ()=> 'join',
 PART_REQ()=> 'part',
 SEND_PUBLIC()=> 'send_public',
 SEND_PRIVATE()=> 'send_private',
 LIST_CHANNELS() => 'list_channels',
 LIST_USERS() => 'list_users',
 );

# utworz gniazdo UDP
my $port = shift ||027;
my $mcast_port = shift ||028;
my $comm = ChatObjects::MComm->new($port,$mcast_port);

# utworz kilka kanalow tematycznych
#tytulopisadres rozsylania grupowego
my $mc = 'ChatObjects::MChannel';
$mc->new('Aktualnosci','Dyskusja biezacych wydarzen', '225.1.0.1',$comm);
$mc->new('Pogoda','Konwersacje o pogodzie','225.1.0.2',$comm);
$mc->new('MojOgrodek', 'Dla tych, ktrzy dbaja o grzadki','225.1.0.3',$comm);
$mc->new('Hobby','Dla wszystkich hobbistow', '225.1.0.4',$comm);
$mc->new('Zwierzaki',' Futerkowi i skrzydlaci domownicy', '225.1.0.5',$comm);

warn "obsluga nadchodzacych zlecen...\n";

while (1) {
my $data;
next unless my ($code,$msg,$addr) = $comm->recv_event;

warn "$code $msg\n" if DEBUG;
do_login($addr,$msg,$comm) && next if $code == LOGIN_REQ;

my $user = ChatObjects::User->lookup_byaddr($addr);
$comm->send_event(ERROR,"prosze sie zarejestrowac",$addr) && next 
 unless defined $user;

$comm->send_event(ERROR,"nieznany kod komunikatu",$addr) && next 
unless my $dispatch = $dispatch{$code};
$user->$dispatch($msg);
}

sub do_login {
my ($addr,$nickname,$comm) = @_;
return $comm->send_event(ERROR,"pseudonim juz wykorzystany",$addr) 
 if ChatObjects::User->lookup_byname($nickname);
my $u = ChatObjects::User->new($addr,$nickname,$comm) or return
$u->send(SET_MCAST_PORT,$comm->port);
}