package IO::Socket::Multicast;
# plik: IO/Socket/Multicast.pm
use strict;
use Carp 'croak';
use IO::Interface 'IFF_MULTICAST';
use vars qw($VERSION @ISA);
@ISA = qw(IO::Socket::INET);
$VERSION = '1.00';

# kolejnosc importowania jest wazna by uniknac ostrzezen o przedefiniowaniu
require IO::Socket;
IO::Socket->import('inet_aton','inet_ntoa');
require "netinet/in.ph";
my $IP_LEVEL = getprotobyname('ip') || 0;

sub new {
my $class = shift;
unshift @_,(Proto => 'udp') unless @_;
$class->SUPER::new(@_);
}

sub configure {
my($self,$arg) = @_;
$arg->{Proto} ||= 'udp';
$self->SUPER::configure($arg);
}

sub mcast_add {
my $sock = shift;
my $mcast_addr = shift || croak 'uycie: $sock->mcast_add($mcast_addr [,$interface])';
my $local_addr = get_if_addr($sock,shift);
my $ip_mreq = inet_aton($mcast_addr).inet_aton($local_addr);
setsockopt($sock,$IP_LEVEL,IP_ADD_MEMBERSHIP(),$ip_mreq);
}

sub mcast_drop {
my $sock = shift;
my $mcast_addr = shift || croak 'uycie: $sock->mcast_drop($mcast_addr [,$interface])';
my $local_addr = get_if_addr($sock,shift);
my $ip_mreq = inet_aton($mcast_addr).inet_aton($local_addr);
setsockopt($sock,$IP_LEVEL,IP_DROP_MEMBERSHIP(),$ip_mreq);
}

sub mcast_if {
my $sock = shift;
if (@_) { # ustaw interfejs wyjsciowy
 my $addr = get_if_addr($sock,shift);
 return setsockopt($sock,$IP_LEVEL,IP_MULTICAST_IF(),inet_aton($addr));
} else { # pobierz interfejs wyjsciowy
 return unless my $result = getsockopt($sock,$IP_LEVEL,IP_MULTICAST_IF());
 $result = substr($result,4,4) if length $result >;
 return find_interface($sock,inet_ntoa($result)); 
}
}

sub mcast_loopback {
my $sock= shift;
if (@_) { # ustaw znacznik loopback
 my $enable = shift;
 return setsockopt($sock,$IP_LEVEL,IP_MULTICAST_LOOP(),$enable ? : 0);
} else {
 return unpack 'I',getsockopt($sock,$IP_LEVEL,IP_MULTICAST_LOOP() );
}
}

sub mcast_ttl {
my $sock= shift;
if (@_) { # ustaw ttl
 my $hops= shift;
 return setsockopt($sock,$IP_LEVEL,IP_MULTICAST_TTL(),pack 'I',$hops);
} else {
 return unpack 'I',getsockopt($sock,$IP_LEVEL,IP_MULTICAST_TTL());
}
}

sub get_if_addr {
my ($sock,$interface) = @_;
return '0.0.0.0' unless $interface;
return $interface if $interface =~ /^\d+\.\d+\.\d+\.\d+$/;
croak "nieznany lub nie skonfigurowany interfejs $interface" 
 unless my $addr = $sock->if_addr($interface);
croak "interfejs nie jest zdolny do rozsylania grupowego"
 unless $sock->if_flags($interface) & IFF_MULTICAST;
return $addr;
}

sub find_interface {
my ($sock,$addr) = @_;
foreach ($sock->if_list) {
 return $_ if $sock->if_addr($_) eq $addr;
}
return;# nie mozna znalezc interfejsu
}

1;