#!/usr/bin/perl -w
# plik: timed_chat_client.pl
# klient systemu pogawedki stosujacy UDP i wydajacy regularnie komunikaty STILL_HERE
use strict;
use IO::Socket;
use IO::Select;
use ChatObjects::ChatCodes;
use ChatObjects::Comm;
use constant ALIVE_INTERVAL =>0;# wysylaj STILL_HERE co0 sekund
$SIG{INT} = $SIG{TERM} = sub { exit 0 };
my ($nickname,$server);
# tablica rozdzielcza dla polecen uzytkownika
my %COMMANDS = ( 
 channels=> sub { $server->send_event(LIST_CHANNELS)},
 join=> sub { $server->send_event(JOIN_REQ,shift)},
 part=> sub { $server->send_event(PART_REQ,shift)},
 users=> sub { $server->send_event(LIST_USERS)},
 public => sub { $server->send_event(SEND_PUBLIC,shift)},
 private=> sub { $server->send_event(SEND_PRIVATE,shift) },
 login=> sub { $nickname = do_login()},
 quit=> sub { undef },
);
# tablica rozdzielcza dla komunikatow serwera
my %MESSAGES = (
 ERROR()=> \&error,
 LOGIN_ACK() => \&login_ack,
 JOIN_ACK()=> \&join_part,
 PART_ACK()=> \&join_part,
 PUBLIC_MSG()=> \&public_msg,
 PRIVATE_MSG()=> \&private_msg,
 USER_JOINS()=> \&user_join_part,
 USER_PARTS()=> \&user_join_part,
 CHANNEL_ITEM() => \&list_channel,
 USER_ITEM() => \&list_user,
);

# Utworz i inicjalizuj gniazdo UDP
my $servaddr = shift || 'localhost';
my $servport = shift ||027;
my $last_alive = 0;
$server = ChatObjects::Comm->new(PeerAddr=> "$servaddr:$servport") or die $@;
# Proba rejestracji w systemie
$nickname = do_login();
die "Nie mozna zarejestrowac.\n" unless $nickname;
# Czytaj polecenia uzytkownika i komunikaty serwera
my $select = IO::Select->new($server->socket,\*STDIN);
LOOP:
while (1) {
my @ready = $select->can_read(ALIVE_INTERVAL);
foreach (@ready) {
 if ($_ eq \*STDIN) {
do_user(\*STDIN) || last LOOP;
 } else {
do_server($_);
 }
}
if (time() - $last_alive > ALIVE_INTERVAL) {
 $server->send_event(STILL_HERE);
 $last_alive = time();
}
}