 #!/usr/bin/perl
 # file: udp_echo_cli3.pl
 # usage: udp_echo_cli3.pl [host] [port]
 # Klient echa z limitami czasowymi i wykrywaniem duplikatow
 use strict;
 use IO::Socket;
 use IO::Select;
 use IO::Getline;

 use constant MAX_MSG_LEN  => 5000;
 use constant TIMEOUT=> 2;
 use constant MAX_RETRIES  => 5;

 my %PENDING;  # tablica asocjacyjna zadan indeksowana ich numerami porzadkowymi
 use constant REQUEST=> 0;# z tymi dwoma polami
 use constant TRIES  => 1;

 # prowadz rejestr wychodzacych i przychodzacych numerow zadan
 y $seqout  = 0;
 my $seqin= 0;

 my $host = shift || 'localhost';
 my $port = shift || 'echo';

 my $sock = IO::Socket::INET->new(Proto=>'udp',PeerAddr=>"$host:$port")
   or die $@;

 my $select = IO::Select->new($sock,\*STDIN);
 my $stdin  = IO::Getline->new(\*STDIN);

 LOOP:
 while (1) {
   my @ready = $select->can_read(TIMEOUT);

   for my $handle (@ready) {
  if ($handle eq \*STDIN) {
 my $length = $stdin->getline($_) or last LOOP;
 next unless $length > 0;
 chomp;
 send_message($seqout++,$_);
  }

  if ($handle eq $sock) {
 my $data;
 $sock->recv($data,MAX_MSG_LEN) or die "recv(): $!\n";
 receive_message($data);
  }

   }

   # obsluguj pozostale komunikaty w przypadku przekroczenia limitu czasu
   do_retries() unless @ready;
 }

 sub send_message {
   my ($sequence,$msg) = @_;

   # wyslij komunikat
   $sock->send("$sequence: $msg") or die "send(): $!\n";

   # oznacz to jako oczekujace
   $PENDING{$sequence}[REQUEST] = $msg;
   $PENDING{$sequence}[TRIES]++;
 }

 sub receive_message {
   my $message = shift;
   my ($sequence,$msg) = $message =~ /^(\d+): (.*)/
  or return warn "zly format komunikatu '$message'!\n";

   # czy to ju byo?
   unless ($PENDING{$sequence}) {
  warn "Odrzucam duplikat komunikatu no = $sequence\n";
  return;
   }

   # ostrzegaj o komunikatach w zlej kolejnosci
   warn "Zla kolejnosc komunikatu no = $sequence\n" if $sequence < $seqin;

   # drukuj wynik
   print $PENDING{$sequence}[REQUEST],' => ',$msg,"\n";

   # pamietaj ostatni numer porzadkowy i usun komunikat z listy oczekujacych
   $seqin = $sequence;
   delete $PENDING{$sequence};
 }

 sub do_retries {
   for my $seq (keys %PENDING) {
  if ($PENDING{$seq}[TRIES] >= MAX_RETRIES) {
 warn "$seq: zbyt wiele prob. Rezygnuje.\n";
 delete $PENDING{$seq};
 next;
  }
  warn "$seq: proba...\n";
  send_message($seq,$PENDING{$seq}[REQUEST]); 
   }
 }