#!/usr/bin/perl
# plik: udp_daytime_multi.pl
# uzycie: udp_daytime_multi.pl host1 host2 host3...

use strict;
use IO::Socket qw(:DEFAULT :crlf);
use constant MAX_MSG_LEN=> 100;
use constant TIMEOUT=> 10;# czekaj 10 sekund na wszystkie odpowiedzi
$/ = CRLF;

$SIG{ALRM} = sub { die "limit czasu uplynal przed nadejsciem wszystkich odpowiedzi\n" };

my $sock = IO::Socket::INET->new(Proto => 'udp') or die $@;
my $port = getservbyname('daytime','udp');

my $host_count = 0;
while (my $host = shift @ARGV) {

my $dest = sockaddr_in($port,inet_aton($host));

if ($sock->send('Hej!',0,$dest)) {
warn "wyslano do $host...\n";
$host_count++;
} else {
warn "$host: $!\n";
}
}

warn "\nCzekam na odpowiedzi...\n";

alarm(TIMEOUT);
while ($host_count-- > 0) {
my $daytime;

unless ($sock->recv($daytime,MAX_MSG_LEN)) {
 warn $!,"\n";
 next;
}

my $hostname = gethostbyaddr($sock->peeraddr,AF_INET) || $sock->peerhost;
chomp($daytime);
print "$hostname: $daytime\n";
}
alarm(0);