#!/usr/bin/perl
# plik: udp_daytime.pl
# uzycie: udp_daytime_cli.pl [host] [port]

use strict;
use Socket qw(:DEFAULT :crlf);
$/ = CRLF;

use constant DEFAULT_HOST => 'localhost';  # interfejs lokalny (loopback)
use constant DEFAULT_PORT => 'daytime'; # usuga zegarynki (daytime)
se constant MAX_MSG_LEN  => 100;

my $host = shift || DEFAULT_HOST;
my $port = shift || DEFAULT_PORT;

my $protocol = getprotobyname('udp');
$port  = getservbyname($port,'udp') unless $port =~ /^\d+$/;
my $data;

socket(SOCK, AF_INET, SOCK_DGRAM, $protocol) or die "niepowodzenie socket(): $!";
my $dest_addr = sockaddr_in($port,inet_aton($host));

send(SOCK,"Ktora godzina?",0,$dest_addr)or die "niepowodzenie send(): $!";
recv(SOCK,$data,MAX_MSG_LEN,0)or die "niepowodzenie recv(): $!";

chomp($data);
print $data,"\n";
