#!/usr/bin/perl
# plik: gab7.pl
# uzycie: gab7.pl [host] [port]
# Interakcyjny klient TCP uzywajacy poll() do multipleksowania

use strict;
use IO::Socket;
use IO::Poll 0.04 qw(POLLIN POLLOUT POLLERR POLLHUP);
use Errno qw(EWOULDBLOCK);
use constant MAXBUF => 8192;
$SIG{PIPE} = 'IGNORE';
my ($to_stdout,$to_socket,$stdin_done,$sock_done);

my $host = shift or die "Uycie: pollnet.pl host [port]\n";
my $port = shift || 'echo';
my $socket  = IO::Socket::INET->new("$host:$port") or die $@;

my $poll = IO::Poll->new() or die "Nie mozna utworzyc obiektu IO::Poll";
$poll->mask(\*STDIN => POLLIN);
$poll->mask($socket => POLLIN);

$socket->blocking(0);  # wylacz blokowanie na gniezdzie
STDOUT->blocking(0);# i na STDOUT

while ($poll->handles) {

  $poll->poll;
  # obsluga uchwytow gotowych do odczytu
  for my $handle ($poll->handles(POLLIN|POLLHUP|POLLERR)) {

 if ($handle eq \*STDIN) {
$stdin_done++ unless sysread(STDIN,$to_socket,2048,length $to_socket);
 }

 elsif ($handle eq $socket) {
$sock_done++ unless sysread($socket,$to_stdout,2048,length $to_stdout);
 }
  }

  # obsluga uchwytow gotowych do zapisu
  for my $handle ($poll->handles(POLLOUT|POLLERR)) {

 if ($handle eq \*STDOUT) {
my $bytes = syswrite(STDOUT,$to_stdout);
unless ($bytes) {
  next if $! == EWOULDBLOCK;
  die "fiasko zapisu na stdout: $!";
}
substr($to_stdout,0,$bytes) = '';
 }

 elsif ($handle eq $socket) {
my $bytes = syswrite($socket,$to_socket);
unless ($bytes) {
  next if $! == EWOULDBLOCK;
  die "fiasko zapisu do gniazda: $!";
 }
 substr($to_socket,0,$bytes) = '';
 }
  }

} continue {
  my ($outmask,$inmask,$sockmask) = (0,0,0);

  $outmask  = POLLOUT if  length $to_stdout > 0;

  $inmask= POLLIN  unless length $to_socket >= MAXBUF 
 or ($sock_done || $stdin_done);

  $sockmask  = POLLOUT unless length $to_socket == 0or $sock_done;
  $sockmask |= POLLIN  unless length $to_stdout >= MAXBUF or $sock_done;

  $poll->mask(\*STDIN  => $inmask);
  $poll->mask(\*STDOUT => $outmask);
  $poll->mask($socket  => $sockmask);

  $socket->shutdown(1) if $stdin_done and !length($to_socket);
}