#!/usr/bin/perl
# plik: web_fetch_p.pl

use strict;
use HTTPFetch;
use IO::Socket;
use IO::Select;

my %CONNECTIONS;  # odwzoruj gniazdo => obiekt

# utworz dwa obiekty IO::Select do obslugi zapisywania i czytania
my $readers = IO::Select->new;
my $writers = IO::Select->new;

# tworzy polaczenia z listy adresow url z wiersza polecen
while (my $url = shift) {
next unless my $object = HTTPFetch->new($url);
$CONNECTIONS{$object->socket} = $object;  # zapamietaj jego gniazdo
$writers->add($object->socket);  # monitoruj do zapisu
}

while (my ($readable,$writable) = IO::Select->select($readers,$writers)) {

foreach (@$writable) {  # uchwyt jest gotow do zapisywania
my $obj = $CONNECTIONS{$_}; # odzyskaj obiekt HTTP
my $result = $obj->send_request;  # sprobuj wyslac zadanie
$readers->add($_) if $result;  # przeslanie pomylne, zatem monitoruj obiekt do odczytu
$writers->remove($_); # i usun z listy obiektow monitorowanych do zapisu
}

foreach (@$readable) {  # uchwyt jest gotowy do czytania
my $obj = $CONNECTIONS{$_};  # odzyskaj obiekt HTTP
my $result = $obj->read;  # odczytaj dane
unless ($result) {  # usun w razie bledu
$readers->remove($_);  
delete $CONNECTIONS{$_};
}
}

last unless $readers->count or $writers->count;  # zakoncz gdy juz nie ma nic do zrobienia
}