#!/usr/bin/perl
# plik: eliza_nonblock.pl

use strict;
use Chatbot::Eliza::Polite;
use IO::Socket;
use IO::LineBufferedSet;

my %SESSIONS;# tablica asocjacyjna obiektw Elizy, indeksowana gniazdem

use constant PORT => 12000;

my $listen_socket = IO::Socket::INET->new(LocalPort => PORT,
Listen => 20,
Proto  => 'tcp',
Reuse  => 1);
die "Nie mona utworzy gniazda nasuchu: $@" unless $listen_socket;
my $session_set = IO::LineBufferedSet->new($listen_socket);

warn "Czekam na poczenia...\n";

while (1) {

  my @ready = $session_set->wait;

  for my $session (@ready) {

 my $eliza;
 if ( !($eliza = $SESSIONS{$session}) ) { # nowa sesja
$eliza = $SESSIONS{$session} = new Chatbot::Eliza::Polite;
$session->write($eliza->welcome);
next;
 } 

 # jeli tu dotarlimy to jest to istniejca (w toku) sesja
 my $user_input;
 my $bytes = $session->getline($user_input);
 if ($bytes > 0) {
chomp($user_input);
$session->write($eliza->one_line($user_input));
 }

 $session->close if !$bytes || $eliza->done;

  }  # end for my $handle (@ready)
}