#!/usr/bin/perl
# plik: eliza_inetd.pl

use strict;
use Chatbot::Eliza;
use IO::Socket;
use POSIX 'WNOHANG';

use constant TIMEOUT => 1; # 1 minute
my $timeout  = shift || TIMEOUT;

# obsluga sygnau CHLD
$SIG{CHLD} = sub { while ( waitpid(-1,WNOHANG)>0 ) { } };

# odzyskaj gniazdo z STDIN
die "STDIN nie jest gniazdem" unless -S STDIN;
my $listen_socket = IO::Socket->new_from_fd(\*STDIN,"+<")
  or die "Can't Nie mona utworzy gniazda: $!";

while (1) {

  my $connection = eval {
 local $SIG{ALRM} = sub { die "timeout" };
 alarm ($timeout * 60);
 return $listen_socket->accept;
  };
  alarm(0);
  exit 0 unless $connection;

  die "Nie mona rozwidli: $!" unless defined (my $child = fork());
  if ($child == 0) {
 $listen_socket->close;
 interact($connection);
 exit 0;
  }
  $connection->close;
}
sub interact {
  my $sock = shift;
  STDIN->fdopen($sock,"<")  or die "Nie mona zamieni STDIN: $!";
  STDOUT->fdopen($sock,">") or die "Nie mona zamieni STDOUT: $!";
  STDERR->fdopen($sock,">") or die "Nie mona zamieni STDERR: $!";
  STDOUT->autoflush(1);
  my $bot = Chatbot::Eliza->new;
  $bot->command_interface;
}
sub Chatbot::Eliza::_testquit { 
  my ($self,$string) = @_; 
  return 1 unless defined $string;  # test for EOF 
  foreach (@{$self->{quit}}) { return 1 if $string =~ /\b$_\b/i };
}