#!/usr/bin/perl -T
# plik: pop_fetch.pl

use strict;
use lib '.';

use PopParser;
use PromptUtil;
use Carp qw(carp confess);

use constant HTML_VIEWER  => 'lynx %s';
use constant IMAGE_VIEWER => 'xv -';
use constant MP3_PLAYER=> 'mpg123 -';
use constant WAV_PLAYER=> 'wavplay %s';
use constant SND_PLAYER=> 'aplay %s';

$ENV{PATH} = '/bin:/usr/bin:/usr/X11/bin:/usr/local/bin';
delete $ENV{$_} foreach qw/ENV IFS BASH_ENV CDPATH/;

my($username,$host) = shift =~ /([\w.-]+)@([\w.-]+)/;
$username or die <<'USAGE';
Uzycie: pop_parse.pl uytkownik@pop.serwer
USAGE
;

my $entity;
$SIG{INT} = sub { exit 0 };

my $pop = PopParser->new($host) or die "Poczony z hostem: $!\n";
my $passwd = get_passwd($username,$host);

my $message_count = $pop->apop($username => $passwd) 
|| $pop->login($username => $passwd)
or die "Nie mona zarejestrowa si : ",$pop->message,"\n";

print "Masz ",$message_count+=0," wiadomoci w skrzynce.\n\n";
or my $msgnum (1..$message_count) {
print "Wiadomo $msgnum z $message_count\n";

print_header($pop->top($msgnum));
if (prompt("\nCzyta (t/n)",'t') eq 't') {
next unless $entity = $pop->get($msgnum);
display_entity($entity);
$entity->purge;
}

if (prompt('Usun (t/n)','n') eq 't') {
  $pop->delete($msgnum);
}
} continue { print "\n" }

# drukuj wiersz podsumowania zawartoci nagwka
sub print_header {
my $header = join '',@{shift()};
$header =~ s/\n\s+/ /gm;
my (%fields) = $header =~ /([\w-]+):\s+(.+)$/mg;
print join "\t",@fields{'Date','From','Subject'},"\n";
}

# przegldaj wiadomo
sub display_entity {
my $entity = shift;

# najpierw nagwek
my $head= $entity->head;
$head->print if $head->get('From');  # drukuj cay nagwek, jeli jest najwyszego poziomu

# teraz zajmij sie treci
print "\n";

# wiadomo wieloczeciowa
if ($entity->is_multipart) {
handle_multipart($entity);
} else {  # wiadomo zoona z jednej czci
display_part($entity);
}
}

# wywoaj dla przetworzenia wszystkich czci wieloczciowej wiadomoci MIME
sub handle_multipart {
my $entity = shift;
my @parts  = $entity->parts;

# oddziel czeci text/plain od innych
my @text= grep $_->mime_type eq 'text/plain',@parts;
my @attachments  = grep $_->mime_type ne 'text/plain',@parts;

# wywietl wszystkie czci typu text/plain
display_part($_) foreach (@text);

return unless my $atcount = @attachments;

my $prompt = $atcount > 1 ? "\nTa wiadomo posiada $atcount zacznikw.  Wywietli je (t/n)?"
: "\nTa wiadomo ma zacznik.  Chcesz go zobaczy (t/n)?";
return unless prompt($prompt,'t') eq 't';

for (my $i=0;$i<@attachments;$i++) {
print "\tZacznik ",$i+1," z ".@attachments,"\n";
display_entity($attachments[$i])
}
}

# przegldaj zawarto danej czci wiadomoci
sub display_part {
my $part = shift;

my $head = $part->head;
my $type = $head->mime_type;
my $description= $head->get('Content-Description');
my ($default_name)= $head->get('Content-Disposition') =~ /filename="([^\"]+)"/;
my $body = $part->bodyhandle;

# typ text/plain
return $body->print if $type eq 'text/plain';

# oraz typ inny niz text/plain
my $viewer = get_viewer($type);
my $prompt = $viewer ? "\n<p>odgld, <z>apisz lub <n>astpny" : "\n<z>apisz lub za<k>ocz";

print "\tTyp: $type.\n";
print "\tOpis: $description\n" if $description;
print "\tNazwa pliku: $default_name\n"if $default_name;

while ( (my $action = prompt ($prompt,'z')) =~ /[zp]/) {
save_body($body,$default_name)  if $action eq 'z';
display_body($body,$viewer)  if $action eq 'p';
}

}

# wywoaj te procedure, aby zapisa zacznik na dysk
sub save_body {
my($body,$default_name) = @_;
my $open_ok = 0;
my $path;
  while (!$open_ok) {
  $path = prompt('Zapisz do pliku lub <n>astpny ',"./$default_name");
  return if $path eq 'n';
  warn "Za nazwa pliku, sprbuj ponownie.\n" and next if $path =~ m!^/|(?:^|/)\.\./!;
  warn "Za nazwa pliku, sprbuj ponownie.\n" and next unless $path =~ m!^([/\w._-]+)$!;
  $open_ok = open(F,">$1");
  warn "Nie mona otworzy $path: $!\n" unless $open_ok;
}
$body->print(\*F) && print "Zapisano do $path\n";
close F || warn "Bd przy zamykaniu $path: $!\n";
}

# wywoaj t procedure, aby przejrze tre zacznika
sub display_body {
my($body,$viewer) = @_;

my $file = $body->path;
if ($file && $viewer =~ s/%s/$file/g) {# przegldarka otwiera $file
  system("$viewer $file") && return warn "Nie mona uruchomi przegldarki: $!\n";
} else { # przegldarka otwiera zacznik z STDIN
  local $SIG{PIPE}='IGNORE';
  open(V,"| $viewer")  || return warn " Nie mona uruchomi przegldarki: $!\n";
  $body->print(\*V);
  close V;
}
}

# odszukaj przegldarke dla danego typu MIME
sub get_viewer {
my $type = shift;
return HTML_VIEWERif $type eq 'text/html';
return IMAGE_VIEWER  if $type =~ m!^image/!;
return MP3_PLAYER if $type =~ m!^audio/(x-)?mpeg!;
return SND_PLAYER if $type =~ m!^audio/!;
return;
}

END {  
$entity->purge if defined $entity;
}