    #!/usr/bin/perl
    # plik: simple_parse.pl

    use strict;
    use MIME::Parser;

    my $file = shift;
    open F,$file or die "nie mona otworzyc pliku $file: $!\n";

    # utworz i skonfiguruj parser
    my $parser = MIME::Parser->new;
    $parser->output_dir("/tmp");

    # parse the file
   my $entity = $parser->parse(\*F);

   print "From      = ",$entity->head->get('From');
   print "Subject   = ",$entity->head->get('Subject');
   print "MIME type = ",$entity->mime_type,"\n";
   print "Parts     = ",scalar $entity->parts,"\n";
   for my $part ($entity->parts) {
   print "\t",$part->mime_type,"\t",$part->bodyhandle->path,"\n";
   }

   $entity->purge;