    #!/usr/bin/perl
    # plik: simple_mime.pl

    use strict;
    use MIME::Entity;

    # utworz wiadomosc MIME najwyzszego poziomu
    my $msg = MIME::Entity->build(From    => 'lstein@lsjs.org',
                                  To      => 'jdoe@acme.org',
                                  Subject => 'Greetings!',
                                  Type    => 'multipart/mixed');

    # dolacz wiadomosc
   my $greeting  <<END;
   Czesc John,

   Oto cos dla Ciebie do przesluchania.

   Milych wrazen!  
   L
   END

   $msg->attach(Type     => 'text/plain',
                Encoding => '7bit',
                Data     => $greeting);

   # dolacz plik audio
   $msg->attach(Type        => 'audio/wav',
                Encoding    => 'base64',
                Description => 'Picard mowi "You will be assimilated"',
                Path        => "$ENV{HOME}/News/sounds/assimilated.wav");

   # dolacz podpis
   $msg->sign(File=>"$ENV{HOME}/.signature");

   # i wyslij to uzywajac "smtp"
   $msg->send('smtp');