#!/usr/bin/perl -w
# plik: ftp_mirror.pl
use strict;
use Net::FTP;
use File::Path;
use Getopt::Long;
use constant USAGEMSG => <<USAGE;
Uzycie: ftp_mirror.pl [opcje] host:/sciezka/do/katalogu
Opcje: 
--user<user>Nazwa uzytkownika
--pass<pass>Haslo
--hash Raport o postepie
--verbose Komunikaty opisowe
USAGE
my ($USERNAME,$PASS,$VERBOSE,$HASH);
die USAGEMSG unless GetOptions('user=s'=> \$USERNAME,
 'pass=s'=> \$PASS,
 'hash' => \$HASH,
 'verbose' => \$VERBOSE);
die USAGEMSG unless my ($HOST,$PATH) = $ARGV[0]=~/(.+):(.+)/;
my $ftp = Net::FTP->new($HOST) or die "Brak poczenia: $@\n";
$ftp->login($USERNAME,$PASS) or die "Fiasko login(): ",$ftp->message;
$ftp->binary;
$ftp->hash(1) if $HASH;
do_mirror($PATH);
$ftp->quit;
exit 0;
# gwny podprogram, ktry rozpoczyna odzwierciedlanie katalogu
sub do_mirror {
my $path = shift;
return unless my $type = find_type($path);
my ($prefix,$leaf) = $path =~ m!^(.*?)([^/]+)/?$!;
$ftp->cwd($prefix) if $prefix;
return get_file($leaf)if $type eq '-';# zwykly plik
return get_dir($leaf)if $type eq 'd';# katalog
warn "Nie wiadomo co zrobi z plikiem typu $type. Pominite.";
}
# odzwierciedlaj plik
sub get_file {
my ($path,$mode) = @_;
my $rtime = $ftp->mdtm($path);
my $rsize = $ftp->size($path);
$mode = (parse_listing($ftp->dir($path)))[2] unless defined $mode;
my ($lsize,$ltime) = stat($path) ? (stat(_))[7,9] : (0,0);
if ( defined($rtime) and defined($rsize) 
 and ($ltime >= $rtime) 
 and ($lsize == $rsize) ) {
 warn "Pobieranie pliku $path: nie jest nowszy od kopii lokalnej.\n" if $VERBOSE;
 return;
}
warn "Pobieranie pliku $path\n" if $VERBOSE;
$ftp->get($path) or (warn $ftp->message,"\n" and return);
chmod $mode,$path if $mode;
}
# odzwierciedlaj katalog rekursywnie
sub get_dir {
my ($path,$mode) = @_;
my $localpath = $path;
-d $localpath or mkpath $localpath or die "fiasko mkpath: $!";
chdir $localpath or die "fiasko chdir na $localpath: $!";
chmod $mode,'.' if $mode;
my $cwd = $ftp->pwd or die "fiasko pwd: ",$ftp->message;
$ftp->cwd($path) or die "fiasko cwd: ",$ftp->message;
warn "Pobieranie katalogu $path/\n" if $VERBOSE;
foreach ($ftp->dir) {
 next unless my ($type,$name,$mode) = parse_listing($_);
 next if $name =~ /^(\.|\.\.)$/;# pomin "." i ".."
 get_dir ($name,$mode) if $type eq 'd';
 get_file($name,$mode) if $type eq '-';
 make_link($name)if $type eq 'l';
}
$ftp->cwd($cwd)or die "fiasko cwd: ",$ftp->message;
chdir '..';
}
# podprogram, ktry okresla, czy scieka jest katalogiem czy plikiem
sub find_type {
my $path = shift;
my $pwd = $ftp->pwd;
my $type = '-';# przyjmij, e to jest zwyky plik
if ($ftp->cwd($path)) {
 $ftp->cwd($pwd);
 $type = 'd';
}
return $type;
}
# Prba odzwierciedlenia dowizania symbolicznego  dziaa tylko dla wzgldnych cieek docelowych.
sub make_link {
my $entry = shift;
my ($link,$target) = split /\s+->\s+/,$entry;
return if $target =~ m!^/!;
warn "Symlink: $link -> $target\n" if $VERBOSE;
return symlink $target,$link;
}
# analiza wydruku zawartoci katalogu 
# -rw-r--r--1 rootroot 312 Aug11994 welcome.msg
sub parse_listing {
my $listing = shift;
return unless my ($type,$mode,$name) =
 $listing =~ /^([a-z-])([a-z-]{9})# -rw-r--r--
\s+\d* # 1
0(?:\s+\w+){2}# root root
1\s+\d+ # 312
2\s+\w+\s+\d+\s+[\d:]+ # Aug 1 1994
3\s+(.+)# welcome.msg
4$/x;
5return ($type,$name,filemode($mode));
6}
7# przekszta tryby symboliczne na wartosci semkowe
8sub filemode {
9my $symbolic = shift;
0my (@modes) = $symbolic =~ /(...)(...)(...)$/g;
1my $result;
2my $multiplier = 1;
3while (my $mode = pop @modes) {
4 my $m = 0;
5 $m += 1 if $mode =~ /[xsS]/;
6 $m += 2 if $mode =~ /w/;
7 $m += 4 if $mode =~ /r/;
8 $result += $m * $multiplier if $m > 0;
9 $multiplier *= 8;
0}
1$result;
}