#!/usr/bin/perl
# plik: change_passwd_ssh.pl
use strict;
use Net::Telnet;
use Getopt::Long;
use IO::Pty;
use POSIX 'setsid';
use constant PROMPT  => '/[%>] $/';
use constant DEBUG => 1;
use constant USAGEMSG => <<USAGE;
Uzycie: change_passwd_ssh.pl [opcje] komputer1, komputer2, ...
Opcje: 
  --user  <user>  Nazwa uzytkownika
  --old<pass>  Obecne haso
  --new<pass>  Nowe haso
USAGE
my ($USER,$OLD,$NEW);
die USAGEMSG unless GetOptions('user=s'  => \$USER,
 'old=s'=> \$OLD,
 'new=s'=> \$NEW);
$USER ||= $ENV{LOGNAME};
$OLD  or die "podaj obecne haso za pomoca opcji --old\n";
$NEW  or die "podaj nowe haso za pomoca opcji --new\n";
change_passwd($_,$USER,$OLD,$NEW) foreach @ARGV;
sub change_passwd {
  my ($host,$user,$oldpass,$newpass) = @_;
  my $ssh = do_cmd('ssh',"-l$user",$host) 
 or die "nie udao si uruchomi podprocesu ssh";
  my $shell = Net::Telnet->new(Fhopen => $ssh);
  $shell->binmode(1);
  $shell->input_log('passwd.log') if DEBUG;
  $shell->errmode('return');
  $shell->waitfor('/password: /');
  $shell->print($oldpass);
  $shell->waitfor(PROMPT) or return warn "host odmw rejestracji: niepoprawne haso?\n";
  $shell->print('passwd');
  $shell->waitfor('/Old password:/') or return warn "$host: ",$shell->errmsg,"\n";
  $shell->print($oldpass);
  my($pre,$match) = $shell->waitfor(Match => '/Incorrect password/',
Match => '/New password:/') or return warn "$host: ",$shell->errmsg,"\n";
  $match =~ /New/ or return warn "$host: niepoprawne haso.\n";
  $shell->print($newpass);
  ($pre,$match) = $shell->waitfor(Match => '/Bad password/',
  Match => '/Re-enter new password:/') or return warn "$host: ",$shell->errmsg,"\n";
  $match =~ /Re-enter/ or return warn "$host: Nowe haso odrzucone.\n";
  $shell->print($newpass);
  $shell->waitfor('/Password changed\./')
 or return warn "$host: ",$shell->errmsg,"\n";
  print "Haso zmieniono dla $user na $host.\n";
}
sub do_cmd {
  my ($cmd,@args) = @_;
  my $pty = IO::Pty->new or die "fiasko Pty: $!";
  defined (my $child = fork) or die "nie mozna rozwidli: $!";
  return $pty if $child;
  setsid();
  my $tty = $pty->slave;
  $pty->make_slave_controlling_terminal();
  close $pty;
  STDIN->fdopen($tty,"<")or die "STDIN: $!";
  STDOUT->fdopen($tty,">")  or die "STDOUT: $!";
  STDERR->fdopen($tty,">")  or die "STDERR: $!";
  close $tty;
  $| = 1;
  exec $cmd,@args;
  die "fiasko exec: $!";
}