#!/usr/bin/perl
# plik: change_passwd.pl
use strict;
use Net::Telnet;
use Getopt::Long;
use constant DEBUG => 1;
use constant USAGEMSG => <<USAGE;
Uzycie: change_passwd.pl [opcje] komputer1, komputer2, ...
Opcje: 
  --user  <user>  Nazwa uytkownika
  --pass  <pass>  Obecne haso
  --new<pass>  Nowe haso
USAGE
my ($USER,$OLD,$NEW);
die USAGEMSG unless GetOptions('user=s'  => \$USER,
'old=s'=> \$OLD,
'new=s'=> \$NEW);
$USER ||= $ENV{LOGNAME};
$OLD  or die "podaj obecne haso za pomoc opcji --old\n";
$NEW  or die "podaj nowe haso za pomoc opcji --new\n";
change_passwd($_,$USER,$OLD,$NEW) foreach @ARGV;
sub change_passwd {
  my ($host,$user,$oldpass,$newpass) = @_;
  my $shell = Net::Telnet->new($host);
  $shell->input_log('passwd.log') if DEBUG;
  $shell->errmode('return');
  $shell->login($user,$oldpass) or return warn "$host: ",$shell->errmsg,"\n";
  $shell->print('passwd');
  $shell->waitfor('/Old password:/') or return warn "$host: ",$shell->errmsg,"\n";
  $shell->print($oldpass);
  my($pre,$match) = $shell->waitfor(Match => '/Incorrect password/',
Match => '/New password:/');
  $match =~ /New/ or return warn "$host: Incorrect password.\n";
  $shell->print($newpass);
  ($pre,$match) = $shell->waitfor(Match => '/Bad password/',
 Match => '/Re-enter new password:/');
  $match =~ /Re-enter/ or return warn "$host: Odrzucono nowe haso.\n";
  $shell->print($newpass);
  $shell->waitfor('/Password changed\./')
 or return warn "$host: ",$shell->errmsg,"\n";
  print "Haso zmienione dla $user na $host.\n";
}