#!/usr/bin/perl
# plik: tcp_echo_serv1.pl
# uzycie: tcp_echo_serv1.pl [port]
use strict;
use Socket;
use IO::Handle;
use constant MY_ECHO_PORT => 2007;
my ($bytes_out,$bytes_in) = (0,0);
my $port  = shift || MY_ECHO_PORT;
my $protocol = getprotobyname('tcp');
$SIG{'INT'} = sub { 
print STDERR "bajty_wysane = $bytes_out, bajty_odebrane = $bytes_in\n";
exit 0;
};
socket(SOCK, AF_INET, SOCK_STREAM, $protocol) or die "fiasko socket(): $!";
setsockopt(SOCK,SOL_SOCKET,SO_REUSEADDR,1) or die "Nie mona ustawi SO_REUSADDR: $!" ;
my $my_addr = sockaddr_in($port,INADDR_ANY);
bind(SOCK,$my_addr) or die "fiasko bind(): $!";
listen(SOCK,SOMAXCONN) or die "fiasko listen(): $!";
warn "czekam na poczenia nadchodzce do portu $port...\n";
while (1) {
next unless my $remote_addr = accept(SESSION,SOCK);
my ($port,$hisaddr) = sockaddr_in($remote_addr);
warn "Poczenie z [",inet_ntoa($hisaddr),",$port]\n";
SESSION->autoflush(1);
while (<SESSION>) {
$bytes_in  += length($_); 
chomp;
my $msg_out = (scalar reverse $_) . "\n";
print SESSION $msg_out;
$bytes_out += length($msg_out);
}
warn "Poczenie z [",inet_ntoa($hisaddr),",$port] zakoczono\n";
close SESSION;
}
close SOCK;