#!/usr/bin/perl -w
# plik: timed_chat_server.pl
# serwer systemu pogawedki stosujacy UDP, z automatycznym wyrejestrowywaniem nieaktywnych klientow
use strict;
use ChatObjects::ChatCodes;
use ChatObjects::Comm;
use ChatObjects::TimedUser;
use ChatObjects::Channel;

use constant DEBUG =>;
use constant AUTO_LOGOUT =>20;# auto-logout jeli milczy dwie minuty
use constant CHECK_INTERVAL =>30;# usuwaj milczkow co0 sekund

# utworz kilka kanalow tematycznych
ChatObjects::Channel->new('Aktualnosci','Dyskusja nad biezacymi wydarzeniami');
ChatObjects::Channel->new('Pogoda', 'Konwersacje o pogodzie');
ChatObjects::Channel->new('MojOgrodek','Dla tych, ktorzy dbaja o grzadki');
ChatObjects::Channel->new('Hobby','Dla wszystkich hobbistow');
ChatObjects::Channel->new('Zwierzaki', 'Futerkowi i skrzydlaci domownicy');

# tablica rozdzielcza
my %DISPATCH = (
 LOGOFF()=> 'logout',
 JOIN_REQ()=> 'join',
 PART_REQ()=> 'part',
 SEND_PUBLIC()=> 'send_public',
 SEND_PRIVATE()=> 'send_private',
 LIST_CHANNELS() => 'list_channels',
 LIST_USERS() => 'list_users',
 STILL_HERE() => 'still_here',
 );

# utworz gniazdo UDP
my $port = shift ||027;
my $server = ChatObjects::Comm->new(LocalPort=>$port);
warn "obsluga nadchodzacych zlecen...\n";

my $next_check = time() + CHECK_INTERVAL;

while (1) {
next unless my ($code,$msg,$addr) = $server->recv_event;

warn "$code $msg\n" if DEBUG;
do_login($addr,$msg,$server) && next if $code == LOGIN_REQ;

my $user = ChatObjects::TimedUser->lookup_byaddr($addr);
$server->send_event(ERROR,"prosze sie zarejestrowac",$addr) && next 
 unless defined $user;

$server->send_event(ERROR,"nieznany kod zdarzenia",$addr) && next 
 unless my $dispatch = $DISPATCH{$code};
$user->$dispatch($msg);
} continue {
if (time() > $next_check) {
 auto_logoff();
 $next_check = time() + CHECK_INTERVAL;
}
}

sub auto_logoff {
warn "Szukam nieaktywnych...\n" if DEBUG;
foreach (ChatObjects::TimedUser->users) {
 next if $_->inactivity_interval < AUTO_LOGOUT;
 warn "Auto-logout $_\n" if DEBUG;
 $_->logout;
}
}
sub do_login {
my ($addr,$nickname,$server) = @_;
return $server->send_event(ERROR,"pseudonim juz wykorzystany",$addr) 
 if ChatObjects::TimedUser->lookup_byname($nickname);
return unless ChatObjects::TimedUser->new($addr,$nickname,$server);
}