#!/usr/bin/perl -w
# plik: chat_server.pl
# serwer systemu pogawedki wykorzystujacy protokol UDP
use strict;
use ChatObjects::ChatCodes;
use ChatObjects::Comm;
use ChatObjects::User;
use ChatObjects::Channel;
use constant DEBUG => 0;

# utworz kilka kanalow tematycznych
ChatObjects::Channel->new('Aktualnoci','Dyskusja nad biecymi wydarzeniami');
ChatObjects::Channel->new('Pogoda', 'Konwersacje o pogodzie');
ChatObjects::Channel->new('MjOgrodek','Dla tych, ktrzy dbaj o grzdki');
ChatObjects::Channel->new('Hobby','Dla wszystkich hobbistw');
ChatObjects::Channel->new('Zwierzaki', 'Futerkowi i skrzydlaci domownicy');

# tablica rozdzielcza
my %DISPATCH = (
 LOGOFF()=> 'logout',
 JOIN_REQ()=> 'join',
 PART_REQ()=> 'part',
 SEND_PUBLIC()=> 'send_public',
 SEND_PRIVATE()=> 'send_private',
 LIST_CHANNELS() => 'list_channels',
 LIST_USERS() => 'list_users',
 );

# utworz gniazdo UDP
my $port = shift ||027;
my $server = ChatObjects::Comm->new(LocalPort=>$port);
warn "obsluga nadchodzacych zlecen...\n";

while (1) {
next unless my ($code,$msg,$addr) = $server->recv_event;

warn "$code $msg\n" if DEBUG;
do_login($addr,$msg,$server) && next if $code == LOGIN_REQ;

my $user = ChatObjects::User->lookup_byaddr($addr);
$server->send_event(ERROR,"prosze sie zarejestrowac",$addr) && next 
 unless defined $user;

$server->send_event(ERROR,"nieznany kod zdarzenia",$addr) && next 
 unless my $dispatch = $DISPATCH{$code};
$user->$dispatch($msg);
}

sub do_login {
my ($addr,$nickname,$server) = @_;
return $server->send_event(ERROR,"pseudonim ju wykorzystany",$addr) 
 if ChatObjects::User->lookup_byname($nickname);
return unless ChatObjects::User->new($addr,$nickname,$server);
}