#!/usr/bin/perl
# plik: udp_echo_cli2.pl
# uzycie: udp_echo_cli2.pl [host] [port]
# Klient uslugi echo z limitem czasowym
use strict;
use IO::Socket;

use constant MAX_MSG_LEN=> 5000;
use constant TIMEOUT=> 2;
use constant MAX_RETRIES=> 5;
my $msg_in;

my $host = shift || 'localhost';
my $port = shift || 'echo';

my $sock = IO::Socket::INET->new(Proto=>'udp',PeerAddr=>"$host:$port")
or die $@;

while (<>) {
chomp;

my $retries = 0;
do {
 $sock->send($_) or die "send() fiasko: $!";
 eval {
local $SIG{ALRM} = sub { ++$retries and die "czas przekroczony\n" };
alarm(TIMEOUT);
$sock->recv($msg_in,MAX_MSG_LEN)or die "receive() fiasko: $!";
alarm(0);
 };
 warn "Proba...$retries\n" if $retries;
} while $@ eq "czas przekroczony\n" and $retries < MAX_RETRIES;

die "czas przekroczony\n" if $retries >= MAX_RETRIES;

print $msg_in,"\n";
}

$sock->close;