#!/usr/bin/perl
# plik: urg_recv3.pl

use strict;
use IO::Socket;
use IO::Select;

my $PORT = shift || 2007;

my $listen = IO::Socket::INET->new( Listen => 15,
LocalPort => $PORT,
Reuse=> 1) || die "Nie mona nasluchiwac: $!";
warn "Nasluch na porcie $PORT...\n";

my $ok_to_read_oob = 1;
my $sock = $listen->accept;
my $reader = IO::Select->new($sock);# do monitorowania zwyklych danych
my $except = IO::Select->new;# do monitorowania pilnych danych

while (1) {
my $data;

$except->add($sock) if $ok_to_read_oob;

my ($has_regular,undef,$has_urgent) = IO::Select->select($reader,undef,$except);

if (@$has_urgent) {
 my $r = recv($sock,$data,100,MSG_OOB);
 print $r ? "mam ".length($data)." bajt pilnych danych: $data\n"
 : "recv() error: $!\n";
 $ok_to_read_oob = 0;
 $except->remove($sock);
}

if (@$has_regular) {
 last unless sysread $sock,$data,1024;
 print "mam ",length $data," bajty normalnych danych: $data\n";
 $ok_to_read_oob++;
}

}
