#!/usr/bin/perl
# plik: urg_recv.pl

use strict;
use IO::Socket;
use Fcntl;

my $PORT = shift || 2007;
my ($sock,$data);

$SIG{URG} = sub {
my $r = recv($sock,$data,100,MSG_OOB);
print $r ? ("mam ",length($data)," bajt pilnych danych: $data\n")
: ("recv() error: $!\n");
};

my $listen = IO::Socket::INET->new( Listen => 15,
LocalPort => $PORT,
Reuse=> 1) or die "Nie mozna nasluchiwac: $!";
warn "Nasluch na porcie $PORT...\n";

$sock = $listen->accept;

# okresl posiadacza gniazda, tak aby mozna bylo odebrac sygnal URG
fcntl($sock,F_SETOWN,$$) or die "Nie mozna ustanowic wlasciciela: $!";

# potwierdz odebrane dane
while (sysread $sock,$data,1024) {
print "mam ",length($data)," bajty normalnych danych: $data\n";
}
