#!/usr/bin/perl
# plik: trav_serv.pl

use strict;
use POSIX 'WNOHANG';
use IO::Socket qw(:DEFAULT :crlf);
use Fcntl 'F_SETOWN';
use Text::Travesty;
use IO::Getline;
use Sockatmark;
use constant DEBUG => 1;

my ($gl,$line);

$SIG{CHLD} = sub { 1 while waitpid(-1,WNOHANG) > 0 };
$SIG{URG} = 'IGNORE';

 my $PORT = shift || 2007;
 my $listen = IO::Socket::INET->new( Listen => 15,
 LocalPort => $PORT,
 Reuse=> 1) or die "Can't listen: $!";
 warn "Nasuchuje na porcie $PORT...\n";

 while (my $sock = $listen->accept) {
 my $child = fork;
 die "NIe mona rozwidli: $!"unless defined $child;
 unless ($child > 0) {
  handle_connection($sock);
  exit 0; # potomek nigdy nie powraca
 }
 close $sock;
 }

 # per-connection code
 sub handle_connection {
 my $sock = shift;
 warn "klient poczony...\n" if DEBUG;

 fcntl($sock,F_SETOWN,$$) or die "Nie mona ustawi waciciela: $!";

 local $/ = "$CRLF";
 my $travesty = Text::Travesty->new; 
 $gl = IO::Getline->new($sock);
 $gl->blocking(1);# wcz ponownie tryb blokujacy

 syswrite($sock,"200 Serwer trawestujcy wersja 1.0$CRLF");
 my $command;
 while (my $result = $gl->getline($command)) {
  warn "komenda= $command" if DEBUG;
  chomp $command;

  analyze_file ($travesty),nextif $command eq 'DATA';
  reset_travesty($travesty),next if $command eq 'WYZERUJ';
  make_travesty($travesty,$1),nextif $command =~ /^GENERUJ\s+(\d+)$/;
  $gl->syswrite("204 zakocz $CRLF"),lastif $command eq 'BYE';
  $gl->syswrite("500 nieznana komenda$CRLF");
 }
 warn "klient rozczony...\n" if DEBUG;
 close $sock;
 }

 # analiza pliku
 sub analyze_file {
 my $travesty = shift;
 $travesty->reset;
 $gl->syswrite("201 Wczytywanie danych dane; koczy sama \".\" w linii.$CRLF");
 my $line;
 eval {
  local $SIG{URG} = sub { do_urgent(); die };
  while (my $result = $gl->getline($line)) {
 chomp $line;
 last if $line eq '.';
 $travesty->add($line);
  }
 };
 $gl->syswrite("202 przetworzono ".$travesty->words()." wyrazw$CRLF");
 }

 # trawestuj plik
 sub make_travesty {
 my ($travesty,$words) = @_;
 $gl->syswrite("500 nie przeanalizowano adnych danych$CRLF"),return 
  unless $travesty->words;

 $gl->syswrite("203 trawestacja w toku$CRLF");
 my $abort = 0;
 eval {
  local $SIG{URG} = sub {do_urgent(); $abort++; die };
  while ($words > 0) {
 my $w= $words > 500 ? 500 : $words;
 my $text = $travesty->pretty_text($w);
 $text =~ s/\n/$CRLF/g;
 $gl->syswrite($text);
 $words -= $w;
  }
  $gl->syswrite(".$CRLF");
 };
 if ($abort) {
 warn "make_travesty() anulowane\n" if DEBUG;
 $gl->send('!',MSG_OOB);
 } 
 }

 sub reset_travesty {
 my $t = shift;
 $t->reset;
 $gl->syswrite("205 trawestacja wyzerowana$CRLF");
 }

 sub do_urgent {
 my $data;
 warn "do_urgent()" if DEBUG;
 my $sock = $gl->handle;
 # czytaj do znaku, mieszajc dane
 until ($sock->atmark) {
 my $n = sysread($sock,$data,1024);
 warn "odrzucono $n bajtw\n" if DEBUG;
}

# odczytaj bajt pilnych danych i odrzuc go
warn "wczytano 1 bajt wanych danych\n" if DEBUG;
recv($sock,$data,1,MSG_OOB);

# odeslij do nadawcy bajt pilnych danych
$gl->flush;# oproznij bufor danych
}