#!/usr/bin/perl
# plik: trav_cli.pl

use strict;
use Fcntl 'F_SETOWN';
use IO::Socket qw(:DEFAULT :crlf);
use IO::File;
use IO::Getline;
use Sockatmark;
use constant DEBUG => 1;
$| = 1;

 my $HOST = shift || 'localhost';
 my $PORT = shift || 2007;
 my ($gl,$quit_now,$line); 

$SIG{QUIT} = sub { exit 0 };
$SIG{INT}= sub { ++$quit_now >= 2 && exit 0; warn "Nacinij ponownie ^C, by zakonczyc\n" };
$SIG{URG} = \&do_urgent;

 my $sock = IO::Socket::INET->new("$HOST:$PORT") or die "Nie mona poczy";

 # ustal posiadacza gniazda tak, by mozna bylo odebrac sygnal URG
 fcntl($sock,F_SETOWN,$$) or die "Nie mona ustawi waciciela: $!";

 $gl = IO::Getline->new($sock);
 $gl->blocking(1); # wlacz ponownie tryb blokujacy

 $gl->getline($line) or die "Nieoczekiwane zamkniecie gniazda serwera\n";
 $line =~ /^200/or die "Nie odebrano powitalnego bannera z serwera.\n";

 print "> ";

 while (<>) {# czytaj polecenia ze stdin
 chomp;
 next unless my ($command,$args) = /^(\w+)\s*(.*)/;
 do_analyze($args),nextif $command =~ /^analizuj$/i;
 do_reset($args),nextif $command =~ /^wyzeruj$/i;
 do_get($args),next if $command =~ /^generuj$/i;
 do_bye($args),last if $command =~ /^koniec|quit$/i;
 print_usage();
 } continue {
 $quit_now = 0;
 print "> ";
 }
 $gl->close;

 sub do_analyze {
 my $file = shift;

 my $fh = IO::File->new($file);
 warn "Nie mona otworzy $file: $!\n" and return unless $fh;

 $gl->syswrite("DATA$CRLF");
 return unless $gl->getline($line);
 warn $line and returnunless $line =~ /^201/;

 print "analizuje...";
 my $abort = 0;
 eval {
  local $SIG{INT} = sub { print "przerwano!..."; $abort++; die; };
 my $data;
  while (<$fh>) {
 chomp;
 next unless /\w+/; # unikaj wierszy pustych i z pojedynczym znakiem "."
 $gl->syswrite("$_$CRLF");
  }

  $gl->syswrite(".$CRLF");
 };

 $gl->send("!",MSG_OOB) if $abort;
 return unless $gl->getline($line);
 warn $line and return unless $line =~ /^202 \D*(\d+) words/;
 print "przetworzono $1 wyrazw\n";
 }

 sub do_reset { 
 my $line;
 $gl->syswrite("WYZERUJ$CRLF");
 $gl->getline($line) or die "Nieoczekiwane zamknicie gniazda\n";
 warn $line and return unless $line =~ /^205/;
 print "wyzerowanie pomylne\n";
 }

 sub do_bye{ $gl->syswrite("BYE$CRLF")}

 sub do_get{
 my $words = shift;
 warn "Argument generacji musi by numeryczny\n" and return
  unless $words =~ /^\d+$/;
 $gl->syswrite("GENERUJ $words$CRLF");
 $gl->getline($line) or die "Nieoczekiwane zamknicie gniazda\n";
 warn $line and return unless $line =~ /^203/;
 my $abort = 0;
 eval {
  local $/ = "$CRLF";
  local $SIG{INT}= sub { $abort++; die };
  while ($gl->getline($line)) {
 chomp $line;
 last if $line eq '.';
 print $line,"\n";
  }
 };
 if ($abort) { 
  $gl->send("!",MSG_OOB);
  print "\n[przerwano]\n";
 }
 }

 sub do_urgent {
 my $data;
 warn "do_urgent()" if DEBUG;
 my $sock = $gl->handle;
 # odczytaj do miejsca oznaczonego bajtem pilnych danych i odrzuc te dane
 until ($sock->atmark) {
  my $n = sysread($sock,$data,1024);
  warn "pominito $n bajtw danych\n" if DEBUG;
 }
# odczytaj bajt pilnych danych i odrzuc go
warn "przeczytano 1 bajt wanych danych\n" if DEBUG;
recv($sock,$data,1,MSG_OOB);
$gl->flush;
}

sub print_usage {
print <<END;
komendy: 
analizuj/path/to/file
generuj NNNN
wyzeruj
koniec
END
}