#!/usr/bin/perl -w
# prefork_pipe.pl

use strict;
use IO::Socket;
use IO::File;
use IO::Select;
use Fcntl ':flock';
use Daemon;
use Web;

use constant PREFORK_CHILDREN  => 3;
use constant MAX_REQUEST => 30;
use constant PIDFILE  => "/tmp/prefork.pid";
use constant HI_WATER_MARK  => 5;
use constant LO_WATER_MARK  => 2;
use constant DEBUG => 1;

my $DONE  = 0;# set flag to true when server done
my %STATUS= ();

$SIG{INT}  = $SIG{TERM} = sub { $DONE++ };

my $port = shift || 8080;
my $socket = IO::Socket::INET->new( LocalPort => $port,
Listen => SOMAXCONN,
Reuse  => 1 ) or die "Can't create listen socket: $!";

# create a pipe for IPC
pipe(CHILD_READ,CHILD_WRITE) or die "Can't make pipe!\n";
my $IN = IO::Select->new(\*CHILD_READ);

# create PID file, initialize logging, and go into background
init_server(PIDFILE);

# prefork some children
make_new_child() for (1..PREFORK_CHILDREN);  

while (!$DONE) {

  if ($IN->can_read) { # got a message from one of the children
 my $message;
 next unless sysread(CHILD_READ,$message,4096);
 my @messages = split "\n",$message;
 foreach (@messages) {
next unless my ($pid,$status) = /^(\d+) (.+)$/;
if ($status ne 'done') {
  $STATUS{$pid} = $status;
} else {
  delete $STATUS{$pid};
}
41 }
42  }

43  # get the list of idle children
44  warn join(' ', map {"$_=>$STATUS{$_}"} keys %STATUS),"\n" if DEBUG;
45  my @idle = sort {$a <=> $b} grep {$STATUS{$_} eq 'idle'} keys %STATUS;

46  if (@idle < LO_WATER_MARK) {
47 make_new_child() for (0..LO_WATER_MARK-@idle-1);  # bring the number up
48  } elsif (@idle > HI_WATER_MARK) {
49 my @goners = @idle[0..@idle - HI_WATER_MARK() - 1];# kill the oldest ones
50 my $killed = kill HUP => @goners;
51 warn "killed $killed children\n" if DEBUG;
52  }

53}

54warn "Termination received, killing children\n" if DEBUG;
55kill_children();
56warn "Normal termination.\n";
57exit 0;

58sub make_new_child {
59  my $child = launch_child(\&cleanup_child);
60  if ($child) {  # child > 0, so we're the parent
61 warn "launching child $child\n" if DEBUG;
62  } else {
63 close CHILD_READ; # no need to read from pipe
64 do_child($socket);# child handles incoming connections
65 exit 0;  # child is done
66  }
67}

68sub do_child {
69  my $socket = shift;
70  my $lock = IO::File->new(PIDFILE,O_RDONLY) or die "Can't open lock file: $!";
71  my $cycles = MAX_REQUEST;
72  my $done = 0;

73  $SIG{HUP} = sub { $done++ };
74  while ( !$done && $cycles-- ) {
75 syswrite CHILD_WRITE,"$$ idle\n";
76 my $c;
77 next unless eval {
78local $SIG{HUP} = sub { $done++; die };
79flock($lock,LOCK_EX);
80warn "child $$: calling accept()\n" if DEBUG;
81$c = $socket->accept;
82flock($lock,LOCK_UN);
83 };
84 syswrite CHILD_WRITE,"$$ busy\n";
85 handle_connection($c);
86 close $c; 
87  }
88  warn "child $$ done\n" if DEBUG;
89  syswrite CHILD_WRITE,"$$ done\n";
90  close $_ foreach ($socket,$lock,\*CHILD_WRITE);
91}

92sub cleanup_child {
93  my $child = shift;
94  delete $STATUS{$child};
95}