#!/usr/bin/perl
# plik: eliza_log.pl

use strict;
use Chatbot::Eliza;
use IO::Socket;
use Daemon;

use constant PORT=> 12000;

# obsluga sygnalu CHLD
$SIG{TERM} = $SIG{INT} = sub { exit 0; };

my $port = shift || PORT;
my $listen_socket = IO::Socket::INET->new(LocalPort => $port,
Listen => 20,
Proto  => 'tcp',
Reuse  => 1);
die "Nie mona utworzy gniazda nasuchu: $@" unless $listen_socket;
my $pid = init_server();

log_notice "Serwer oczekuje pocze na porcie $port\n";

while (my $connection = $listen_socket->accept) {
  log_die("NIe mona rozwidli: $!") unless defined (my $child = fork());
  if ($child == 0) {
 $listen_socket->close;
 my $host = $connection->peerhost;
 log_notice("Akceptuje poczenie z %s\n",$host);
 interact($connection);
 log_notice("Poczenie z %s zakoczone\n",$host);
 exit 0;
  }
  $connection->close;
}

sub interact {
  my $sock = shift;
  STDIN->fdopen($sock,"r")  or die "Nie mona przekierowa strumienia STDIN: $!";
  STDOUT->fdopen($sock,"w") or die "Nie mona przekierowa strumienia STDOUT: $!";
  STDERR->fdopen($sock,"w") or die "Nie mona przekierowa strumienia STDERR: $!";
  $| = 1;
  my $bot = Chatbot::Eliza->new;
  $bot->command_interface;
}

sub Chatbot::Eliza::_testquit { 
  my ($self,$string) = @_; 
  return 1 unless defined $string;  # test na EOF 
  foreach (@{$self->{quit}}) { return 1 if $string =~ /\b$_\b/i };
} 

END { 
  log_notice("Serwer koczy prace normalnie\n") if $$ == $pid;
}