#!/usr/bin/perl -T
# plik: eliza_hup.pl

use strict;
use lib '.';
use Chatbot::Eliza;
use IO::Socket;
use Daemon;

use constant PORT=> 1002;
use constant PIDFILE=> '/var/run/eliza_hup.pid';
use constant USER=> 'nobody';
use constant GROUP  => 'nogroup';
use constant ELIZA_HOME => '/home/ftp';

# obsuga sygnau dla zdarze die potomkw
$SIG{TERM} = $SIG{INT} = \&do_term;
$SIG{HUP}  = \&do_hup;

my $port = $ARGV[0] || PORT;
my $listen_socket = IO::Socket::INET->new(LocalPort => $port,
Listen => 20,
Proto  => 'tcp',
Reuse  => 1);
die "Nie mona utworzy gniazda nasuchu: $@" unless $listen_socket;
my $pid = init_server(PIDFILE,USER,GROUP,$port);

log_notice "Serwer oczekuje pocze na porcie $port\n";

while (my $connection = $listen_socket->accept) {
  my $host = $connection->peerhost;
  my $child = launch_child(undef,ELIZA_HOME);
  if ($child == 0) {
 $listen_socket->close;
 log_notice("Akceptuje poczenie z $host\n");
 interact($connection);
 log_notice("Poczenie z $host zakoczone\n");
 exit 0;
  }
  $connection->close;
}

sub interact {
  my $sock = shift;
  STDIN->fdopen($sock,"r")  or die "Nie mona przekierowa strumienia STDIN: $!";
  STDOUT->fdopen($sock,"w") or die "Nie mona przekierowa strumienia STDOUT: $!";
  STDERR->fdopen($sock,"w") or die "Nie mona przekierowa strumienia STDERR: $!";
  $| = 1;
  my $bot = Chatbot::Eliza->new;
  $bot->command_interface;
}

sub do_term {
  log_notice("Odebrano sygna TERM, zakaczam procesy potomkw\n");
  kill_children();
  exit 0;
}

sub do_hup {
  log_notice("Odebrano sygna HUP, inicjuje ponownie...\n");
  log_notice("Zamykam gniazdo nasuchu...\n");
  close $listen_socket;
  log_notice("Zakaczam procesy potomkw...\n");
  kill_children;
  log_notice("Prbuje uruchomi ponownie...\n");
  do_relaunch();
  log_die("Uruchomienie ponowne nie powiodo si. Odchodze");
}

sub Chatbot::Eliza::_testquit { 
  my ($self,$string) = @_; 
  return 1 unless defined $string;  # test for EOF 
  foreach (@{$self->{quit}}) { return 1 if $string =~ /\b$_\b/i };
} 

# Zapobiega ostrzeeniu moduu Chatbot::Eliza
sub Chatbot::Eliza::DESTROY { }

END { 
  log_notice("Serwer koczy prace normalnie\n") if $$ == $pid;
}