#!/usr/bin/perl
# plik: gab5.pl
# uzycie: gab5.pl [host] [port]
# Interakcyjny klient TCP uzywajacy multipleksowania

use strict;
use IO::Socket;
use IO::Select;
use constant BUFSIZE => 1024;

my $host = shift or die "Usage: gab5.pl host [port]\n";
my $port = shift || 'echo';

my $socket  = IO::Socket::INET->new("$host:$port") or die $@;
my $readers = IO::Select->new() or die "Nie mona utworzy obiektu IO::Select";
$readers->add(\*STDIN);
$readers->add($socket);

my $buffer;

while (1) {

  my @ready = $readers->can_read;
  for my $handle (@ready) {

 if ($handle eq \*STDIN) {
if (sysread(STDIN,$buffer,BUFSIZE) > 0) {
  syswrite($socket,$buffer);
} else {
  $socket->shutdown(1);
}
 }

 if ($handle eq $socket) {
if (sysread($socket,$buffer,BUFSIZE) > 0) {
  syswrite(STDOUT,$buffer);
} else {
  warn "Poczenie zamknite przez zdalnego hosta.\n";
  exit 0;
}
 }

  }
}