#!/usr/bin/perl
# plik: eliza_select.pl
use IO::Socket;
use IO::Select;
use Chatbot::Eliza::Polite;
use strict;

my %SESSIONS;#  tablica asocjacyjna obiektw Elizy, indeksowana gniazdem

use constant PORT => 12000;
my $listen_socket = IO::Socket::INET->new(LocalPort => PORT,
Listen => 20,
Proto  => 'tcp',
Reuse  => 1);
die $@ unless $listen_socket;
my $readers = IO::Select->new() or die "Nie mona utworzy obiektu IO::Select";
$readers->add($listen_socket);

warn "Czekam na poczenia...\n";

while (1) {

  my @ready = $readers->can_read;

  for my $handle (@ready) {

 if ($handle eq $listen_socket) {  # nie akceptuj
my $connect = $listen_socket->accept();
my $eliza = $SESSIONS{$connect} = new Chatbot::Eliza::Polite;
syswrite($connect,$eliza->welcome);
$readers->add($connect);
 }

 elsif (my $eliza = $SESSIONS{$handle}) {
my $user_input;
my $bytes = sysread($handle,$user_input,1024);

if ($bytes > 0) {
  chomp($user_input);
  my $response = $eliza->one_line($user_input);
  syswrite($handle,$response);
}

if (!$bytes or $eliza->done) { # sygnalizuj e sesja si zakoczya
  $readers->remove($handle);
  close $handle;
  delete $SESSIONS{$handle};
}
 }

  }  # koniec $handle (@ready)

} # dopki mona czyta_- read()