#!/usr/bin/perl
# plik: gab4.pl
# uycie: gab4.pl [host] [port]

use strict;
use IO::Socket;
use Thread;

use constant BUFSIZE => 1024;
$SIG{TERM} = sub { exit 0 };

my $host = shift or die "Uycie: gab4.pl host [port]";
my $port = shift || 'echo';

my $socket = IO::Socket::INET->new("$host:$port") or die $@;

# nowy wtek czyta z gniazda, drukuje do strumienia STDOUT
my $read_thread = Thread->new(\&host_to_user,$socket);

# glowny wtek czyta ze strumienia STDIN, zapisuje do gniazda
user_to_host($socket);
$socket->shutdown(1);

$read_thread->join;

sub user_to_host {
  my $s = shift;
  my $data;
  syswrite($s,$data) while sysread(STDIN,$data,BUFSIZE);  
}

sub host_to_user {
  my $s = shift;
  my $data;
  syswrite(STDOUT,$data) while sysread($s,$data,BUFSIZE);
  exit 0;
}