#!/usr/bin/perl
# plik: eliza_server.pl

use strict;
use Chatbot::Eliza;
use IO::Socket;
use POSIX 'WNOHANG';

use constant PORT => 12000;

my $quit = 0;

# obsuga sygnau CHLD
$SIG{CHLD} = sub { while ( waitpid(-1,WNOHANG)>0 ) { } };

# obsuga sygnau przerwania z klawiatury lub sygnau TERM
$SIG{INT} = sub { $quit++ };

my $listen_socket = IO::Socket::INET->new(LocalPort => PORT,
Listen => 20,
Proto  => 'tcp',
Reuse  => 1,
Timeout=> 60*60,
  );
die "Nie mona stworzy gniazda nasuchu: $@" unless $listen_socket;
warn "Serwer gotowy.  Czekam na poczenia...\n";

while (!$quit) {

next unless my $connection = $listen_socket->accept;

defined (my $child = fork()) or die "Bd wywoania fork(): $!";
if ($child == 0) {
$listen_socket->close;
interact($connection);
exit 0;
}

$connection->close;
}
sub interact {
my $sock = shift;
TDIN->fdopen($sock,"<")  or die "Nie mona zamieni STDIN: $!";
STDOUT->fdopen($sock,">") or die "Nie mona zamieni STDOUT: $!";
STDERR->fdopen($sock,">") or die "Nie mona zamieni STDERR: $!";
$|=1;
my $bot = Chatbot::Eliza->new;
$bot->command_interface();
}