#!/usr/bin/perl
# plik: eliza_daemon.pl

use strict;
use Chatbot::Eliza;
use IO::Socket;
use IO::File;
use POSIX qw(WNOHANG setsid);

use constant PORT=> 12000;
use constant PID_FILE  => '/var/tmp/eliza.pid';
my $quit = 0;

# obsuga sygnalu CHLD
$SIG{CHLD} = sub { while ( waitpid(-1,WNOHANG)>0 ) { } };
$SIG{TERM} = $SIG{INT} = sub { $quit++ };

my $fh = open_pid_file(PID_FILE);
my $listen_socket = IO::Socket::INET->new(LocalPort => shift || PORT,
Listen => 20,
Proto  => 'tcp',
Reuse  => 1,
Timeout=> 60*60,
);
0die "Nie mona stworzy gniazda nasuchu: $@" unless $listen_socket;

warn "$0 startuje...\n";
my $pid = become_daemon();
print $fh $pid;
close $fh;

while (!$quit) {

next unless my $connection = $listen_socket->accept;

die "Nie mona rozwidli: $!" unless defined (my $child = fork());
if ($child == 0) {
$listen_socket->close;
interact($connection);
exit 0;
}

$connection->close;
}

sub interact {
my $sock = shift;
STDIN->fdopen($sock,"<")  or die "Nie mona zamieni STDIN: $!";
STDOUT->fdopen($sock,">") or die "Nie mona zamieni STDOUT: $!";
STDERR->fdopen($sock,">") or die "Nie mona zamieni STDERR: $!";
$| = 1;
my $bot = Chatbot::Eliza->new;
$bot->command_interface;
}

sub become_daemon {
die "Nie mona rozwidli" unless defined (my $child = fork);
exit 0 if $child; # parent dies;
setsid();  # become session leader
open(STDIN, "</dev/null");
open(STDOUT,">/dev/null");
open(STDERR,">&STDOUT");
chdir '/';  # zamie catalog biecy
umask(0);# wyzeruj maske uprawnie tworzonych plikw
$ENV{PATH} = '/bin:/sbin:/usr/bin:/usr/sbin';
return $$;
}

sub open_pid_file {
my $file = shift;
if (-e $file) {  # oops.  Plik pid ju istnieje
my $fh = IO::File->new($file) || return;
my $pid = <$fh>;
die " Serwer jest uruchomiony z PID $pid" if kill 0 => $pid;
warn " Usuwam plik PID aby zepsu proces serwera $pid.\n";
die " Nie mona usun odniesienia pliku PID $file" unless -w $file && unlink $file;
}
return IO::File->new($file,O_WRONLY|O_CREAT|O_EXCL,0644)
or die "Nie mona utworzy $file: $!\n";
}

sub Chatbot::Eliza::_testquit { 
my ($self,$string) = @_; 
return 1 unless defined $string;  # test for EOF 
foreach (@{$self->{quit}}) { return 1 if $string =~ /\b$_\b/i };
} 

END { unlink PID_FILE if $$ == $pid; }