#!/usr/bin/perl
# plik: get_url2.pl

use strict;
use LWP;
use PromptUtil;
use vars '@ISA';
@ISA = 'LWP::UserAgent';

my $url = shift;

my $agent = __PACKAGE__->new;
my $request  = HTTP::Request->new(GET => $url);

my $response = $agent->request($request);
$response->is_success or die "$url: ",$response->message,"\n";

print $response->content;

sub get_basic_credentials {
  my ($self,$realm,$url) = @_;
  print STDERR "Wprowad nazwe uytkownika i haso dla domeny \"$realm\".\n";
  print STDERR "username: ";
  chomp (my $name = <>);
  return unless $name;
  my $passwd = get_passwd();
  return ($name,$passwd);
}