#!/usr/bin/perl
# plik: follow_chain.pl

use strict;
use LWP;

my $url = shift;

my $agent = LWP::UserAgent->new;
my $request  = HTTP::Request->new(HEAD => $url);

my $response = $agent->request($request);
$response->is_success or die "$url: ",$response->message,"\n";

my @urls;
for (my $r = $response; defined $r; $r = $r->previous) {
  unshift @urls,$r->request->uri . ' (' . $r->status_line .')';
}

print "acuch odpowiedzi:\n\t",join("\n\t-> ",@urls),"\n";;