#!/usr/bin/perl
# stale: scan_newsgroups.pl

use strict;
BEGIN { @AnyDBM_File::ISA = qw(DB_File GDBM_File NDBM_File SDBM_File) }
use AnyDBM_File;
use Getopt::Long;
use Net::NNTP;
use MIME::Entity;
use Fcntl;

# stale
use constant NEWSCACHE => "$ENV{HOME}/.newscache";
use constant USAGE => <<END;
Uycie: scan_newsgroups.pl [opcje] newsgroup1 newsgroup2...
Skanuje grupy dyskusyjne aktualnoi w poszukiwaniu artykuw, ktrych wiersz tematu pasuje do podanego wzorca.
 Opcje:
  -mailto  <addr>  Docelowy e-mail dla odnalezionych artykuw
  -subject <pat>Wzorce dopasowania dla wiersza tematu
  -server  <host>  Serwer NNTP
  -insensitive  Dopasowania bez uwzgledniania wielkoci liter
  -all Wylij wszystkie(domylnie: tylko nie widziane) artykuly
  -verboseOpisowe raporty przebiegu programu
  Opcje mog by skrcone do najmniejszego unikatowego identyfikatora, np. i su.
END

# zmienne globalne
my ($RECIPIENT,$SERVER,$SEND_ALL,$NOCASE,$VERBOSE,@SUBJ_PATTERNS,@NEWSGROUPS);
my (%Seen,%Articles,@Fields);

GetOptions('mailto:s'=> \$RECIPIENT,
  'server:s'=> \$SERVER,
  'subject:s'  => \@SUBJ_PATTERNS,
  'insensitive'=> \$NOCASE,
  'all'  => \$SEND_ALL,
  'verbose' => \$VERBOSE,
 ) or die USAGE;
(@NEWSGROUPS = @ARGV) or die "Wymagana co najmniej jedna nazwa grupy dyskusyjnej.\n",USAGE;
@SUBJ_PATTERNS  or die "Wymagany co najmniej jeden tekst tematu.\n",USAGE;
$RECIPIENT||= $ENV{USER} || $ENV{LOGNAME};

# otwrz poczenie NNTP
my $nntp = Net::NNTP->new($SERVER) or die "Nie mona poczy si do serwera: $!";

# otwrz (inicjalizuj) baz danych buforowanych wiadomoci
tie(%Seen,'AnyDBM_File',NEWSCACHE,O_RDWR|O_CREAT,0640) 
or die "Nie mona otworzy artykuu: $!";

# skompiluj kod dopasowania wzorca
my $patmatch = match_code(@SUBJ_PATTERNS);

# rozwin wzorce dla grup dyskusyjnych aktualnosci
my @groups = expand_newsgroups($nntp,@NEWSGROUPS);

# przeszukaj grupy  wyniki sa zbierane w %Articles
grep_group($nntp,$_,$patmatch) foreach @groups;

# znajd jeszcze te nie widziane artykuy
my @to_fetch = grep {!$Seen{$_}++ || $SEND_ALL} keys %Articles;
warn scalar keys %Articles,' articles, ',scalar @to_fetch," unseen\n" if $VERBOSE;

# wylij wiadomoci
send_mail($nntp,\@to_fetch);
$nntp->quit;
exit 0;

# skonstruuj odsyacz do kodu, ktry dopasowuje co najmniej jeden wzorzec
sub match_code {
my @patterns = @_;
my $flags = $NOCASE ? 'i' : '';
my $code = "sub { my \$t = shift;\n";
$code .= "  my \$matched = 1;\n";
$code .= "  \$matched &&= \$t=~/$_/$flags;\n" foreach @patterns;
$code .= "  return \$matched;\n }\n";
return eval $code or die $@;
}

# rozwi wieloznaczne wzorce w nazwach grup dyskusyjnych
sub expand_newsgroups {
my ($nntp,@patterns) = @_;
my %g;
foreach (@patterns) {
$g{$_}++ and next unless /\*\[\]\?/;
next unless my $g = $nntp->newsgroups($_);
$g{$_}++ foreach keys %$g;
}
return keys %g;
}

# przeszukaj nazwane grupy w poszukiwaniu artykuw z pasujacymi wierszami tematw
sub grep_group {
my ($nntp,$group,$match_sub) = @_;
my $matched = 0;
warn "Przeszukuje $group\n" if $VERBOSE;

my $overview = get_overview($nntp,$group);
for my $o (values %$overview) {
  my ($subject,$msgID) = @{$o}{'Subject','Message-ID'};
  next unless $match_sub->($subject);
  $Articles{$msgID} = $o;
  $matched++;
}

warn "Znaleziono $matched artykuw\n" if $VERBOSE;
return $matched;
}

# sporzadz ogolny przeglad
sub get_overview {
my ($nntp,$group) = @_;
warn "Fetching overview for $group\n" if $VERBOSE;

return unless my ($count,$first,$last) = $nntp->group($group);
@Fields = map {/([\w-]+):/&& $1} @{$nntp->overview_fmt} unless @Fields;

my $over= $nntp->xover([$first,$last]) || return;
foreach (keys %$over) { 
my $h = {};
@{$h}{@Fields,'Message-Number'}= (@{$over->{$_}},"$group:$_"); 
$over->{$_} = $h;
}

return $over;
}

# skonstruuj e-mail do odbiorcy
sub send_mail {
my ($nntp,$to_fetch) = @_;
my $count = @$to_fetch;
my $date = localtime;

warn "Wysyam wiadomo e-mail do $RECIPIENT\n" if $VERBOSE;

# rozpocznij wiadomo MIME
my $message = <<END;
Newsgroups searched: @NEWSGROUPS
Pattern(s): @SUBJ_PATTERNS
Articles matched: $count

END
my $mail = MIME::Entity->build(Subject => "Wiadomosci grup dyskusyjnych z $date",
To => $RECIPIENT,
Type  => 'text/plain',
Encoding => '7bit',
Data  => $message,
  );
attach_article($nntp,$mail,$_) foreach @$to_fetch;
$mail->smtpsend or die "Nie mog wysa wiadomoci e-mail: $!";
$mail->purge;
}

# docz nazwany artyku do wiadomoci
sub attach_article {
my ($nntp,$mail,$messID) = @_;
my $article= $nntp->article($messID) || return;
$mail->attach(Type=> 'message/rfc822',
 Description  => $Articles{$messID}{Subject},
 Filename  => $Articles{$messID}{'Message-Number'},
 Encoding  => '7bit',
 Data=> $article);
}