    #!/usr/bin/perl
    # plik: autoreply.pl

    use strict;
    use Mail::Internet;

    use constant HOME    => (getpwuid($<))[7];
    use constant USER    => (getpwuid($<))[0];
    use constant MSGFILE => HOME . "/.vacation";
    use constant SIGFILE => HOME . "/.signature";

    exit 0 unless -e MSGFILE;
    exit 0 unless my $msg = Mail::Internet->new(\*STDIN);

   my $header = $msg->head;
   # nie odpowiadaj chyba, ze list jest do nas (pole To:)
   my $myname = USER;
   exit 0 unless $header->get('To') =~ /$myname/;

   # nie odpowiadaj, jeli wiadomosc jest oznaczona jako "Bulk"
   exit 0 if $header->get('Precedence') =~ /bulk/i;

   # nie odpowiadaj jeli wiersz From zawiera Daemon, Postmaster, Root lub nas samych jako nadawce
   exit 0 if $header->get('From') =~ /subsystem|daemon|postmaster|root|$myname/i;

   # nie odpowiadaj jeli wiersz Subject zawiera "returned mail"
   exit 0 if $header->get('Subject') =~ /(returned|bounced) mail/i;
   # OK, moemy teraz wygenerowac odpowiedz
   my $reply = $msg->reply;

   # otworz plik z wiadomoscia do przekazania w odpowiedzi
   open (V,MSGFILE) or die "Blad przy otwarciu pliku z wiadomoscia: $!";

   # Dolacz wiadomosc na poczatek odpowiedzi
   my $body = $reply->body;
   unshift (@$body,<V>,"\n");

   # dodaj podpis
   $reply->add_signature(SIGFILE);

   # wyslij wiadomosc
   $reply->send or die;