#!/usr/bin/perl
# plik: tcp_echo_serv2.pl
# uzycie: tcp_echo_serv2.pl [port]
use strict;
use IO::Socket qw(:DEFAULT :crlf);
use constant MY_ECHO_PORT => 2007;
$/ = CRLF;
my ($bytes_out,$bytes_in) = (0,0);
my $quit = 0;
$SIG{INT} = sub { $quit++ }; 
my $port  = shift || MY_ECHO_PORT;
my $sock = IO::Socket::INET->new( Listen => 20, 
LocalPort => $port,
Timeout=> 60*60,
Reuse  => 1) 
or die "Nie mona utworzy gniazda nasuchu: $!\n";
warn "czekam na poczenia nadchodzce do portu $port...\n";
while (!$quit) {
next unless my $session = $sock->accept;
my $peer = gethostbyaddr($session->peeraddr,AF_INET) || $session->peerhost;
my $port = $session->peerport;
warn "Poczenie z [$peer,$port]\n";
while (<$session>) {
$bytes_in  += length($_); 
chomp;
my $msg_out = (scalar reverse $_) . CRLF;
print $session $msg_out;
$bytes_out += length($msg_out);
}
warn "Poczenie z [$peer,$port] zakoczono\n";
close $session;
}
print STDERR "bajty_wysane = $bytes_out, bajty_odebrane = $bytes_in\n";
close $sock;