#!/usr/bin/perl
# file: tcp_echo_cli2.pl
# uzycie: tcp_echo_cli2.pl [host] [port]
# Klient uslugi echo, wersja TCP (IO::Socket)
use strict;
use IO::Socket;
my ($bytes_out,$bytes_in) = (0,0);
my $host = shift || 'localhost';
my $port = shift || 'echo';
my $socket = IO::Socket::INET->new("$host:$port") or die $@;
while (defined(my $msg_out = STDIN->getline)) {
print $socket $msg_out;
my $msg_in = <$socket>;
print $msg_in;
$bytes_out += length($msg_out);
$bytes_in  += length($msg_in);
}
$socket->close or warn $@;
print STDERR "bajty_wysane = $bytes_out, bajty_odebrane = $bytes_in\n";