#!/usr/bin/perl
# plik: gab2.pl
# uzycie: gab2.pl [host] [port]
# Rozwidlajacy klient TCP
use strict;
use IO::Socket qw(:DEFAULT :crlf);
my $host = shift or die "Uzycie: gab2.pl host [port]\n";
my $port = shift || 'echo';
my $socket = IO::Socket::INET->new("$host:$port") or die $@;
my $child = fork();
die "Nie mozna rozwidlic: $!" unless  defined $child;
if ($child) {
$SIG{CHLD} = sub { exit 0 };
user_to_host($socket);
$socket->shutdown(1);
sleep;
} else {
host_to_user($socket);
warn "Polaczenie zakonczone przez obcego hosta.\n";
}
sub user_to_host {
my $s = shift;
while (<>) {
chomp;
print $s $_,CRLF;
}
}
sub host_to_user {
my $s = shift;
$/ = CRLF;
while (<$s>) {
chomp;
print $_,"\n";
}
34}