<?php
/**
 * Doczamy waciw logik biznesow
 */
require_once 'record-label.php';

/**
 * Doczamy klas serwera XML-RPC 
 */
require_once 'XML/RPC/Server.php';

/**
 * Obudowanie XML-RPC dla tej logiki biznesowej
 *
 * @access public
 * @param XML_RPC_Message Komunikat wysyany przez klienta
 * @return XML_RPC_Response Kodowana odpowied serwera
 */
function getRecordsService($args)
{
    $artist  = $args->getParam(0)->scalarval();
    $records = getRecords($artist);
   	$val = XML_RPC_encode($records);
   	$response = new XML_RPC_Response($val);
   	return $response;
}

// mapujemy nazwy metod XML-RPC na funkcje PHP 
$map = array(
        'label.getRecords' => array(
                         'function' => 'getRecordsService'
                        )
       );
       
// tworzymy i uruchamiamy usug
$server = new XML_RPC_Server($map);
?>