<?php
/**
 * Klasa umoliwiajca dostp do konfiguracji
 */
class configuration
{
   /**
    * Bdzie przechowywa sekcj
    */
    private $sections = null;

   /**
    * wybrane rodowisko
    */
    private $environment = 'online';

   /**
    * Metoda definiujca znacznik sekcji
    */
    public function setSection($section)
    {
       $this->sections = $section;
    }

   /**
    * Okrelamy rodowisko konfiguracji
    *
    * Bdzie przywoywana nie przez XML_Unserialiazer, 
    * ale przez uytkownika.
    */
    public function setEnvironment($environment)
    {
        $this->environment = $environment;
    }
    
   /**
    * Pobieramy opcj konfiguracyjn
    *
    * @param string acuch z nazw sekcji
    * @param string acuch z nazw opcji
    * @return mieszana opcja konfiguracji lub false, jeli nie zostaa okrelona 
    */
    public function getConfigurationOption($section, $value)
    {
        foreach ($this->sections as $currentSection) {
        	if ($currentSection->getName() !== $section) {
        		continue;
        	}
        	if (!$currentSection->isEnvironment($this->environment)) {
        		continue;
        	}
        	return $currentSection->getValue($value);
        }
        return null;
    }
}

/**
 * Klasa przechowujca informacje na temat pojedynczej sekcji
 */
class section
{
   /**
    * przechowuje metainformacje
    */
    private $meta = null;

   /**
    * definiuje metainformacje
    */
    public function setMeta($meta)
    {
        if (!isset($meta['name'])) {
        	throw new Exception('Sections require a name.');
        }
        $this->meta = $meta;
    }

   /**
    * Pobieramy nazw sekcji
    */
    public function getName()    
    {
        return $this->meta['name'];
    }

   /**
    * poszukujemy okrelonego rodowiska
    */
    public function isEnvironment($environment)
    {
        if (!isset($this->meta['environment'])) {
            return true;
        }
        return ($environment === $this->meta['environment']);
    }
    
   /**
    * Pobieramy warto z sekcji
    */
    public function getValue($name)
    {
        if (isset($this->$name)) {
        	return $this->$name;
        }
        return null;
    }
}

require_once 'XML/Unserializer.php';
$unserializer = new XML_Unserializer();

// analizuje rwnie atrybuty
$unserializer->setOption(XML_UNSERIALIZER_OPTION_ATTRIBUTES_PARSE, true);
// przechowuje atrybuty w osobnej tablicy
$unserializer->setOption(XML_UNSERIALIZER_OPTION_ATTRIBUTES_ARRAYKEY, 'meta');
// uywamy obiektw zamiast tablic
$unserializer->setOption(XML_UNSERIALIZER_OPTION_COMPLEXTYPE, 'object');
$unserializer->setOption(XML_UNSERIALIZER_OPTION_TAG_AS_CLASSNAME, true);
// Zawsze tworzymy indeksowan tablic dla <section/>
$unserializer->setOption(XML_UNSERIALIZER_OPTION_FORCE_ENUM, array('section'));

$unserializer->unserialize('XML_Parser-001.xml', true);
$config = $unserializer->getUnserializedData();

printf("Folder buforowania: %s\n", $config->getConfigurationOption('paths', 'cache'));
printf("Poczenie z baz danych: %s\n", $config->getConfigurationOption('db', 'dsn'));

$config->setEnvironment('stage');
print "\nZmieniono rodowisko:\n";
printf("Folder buforowania: %s\n", $config->getConfigurationOption('paths', 'cache'));
printf("Poczenie z baz danych: %s\n", $config->getConfigurationOption('db', 'dsn'));
?>