<?php
header('Content-Type: text/xml');
$data = array(
          'artist'  => array(
                        'name'  => 'Elvis Presley',
                        'email' => 'elvis@graceland.com'
                       ),
          'labels'  => array(
                        'Sun Records',
                        'Sony Music'
                       ),
          'records' => array(
                        'Viva Las Vegas',
                        'Hound Dog',
                        'In the Ghetto'
                       )
        );
// zaczamy klas
require_once('XML/Serializer.php');

// tworzymy nowy obiekt
$serializer = new XML_Serializer();

// definiujemy opcje
$serializer->setOption(XML_SERIALIZER_OPTION_XML_DECL_ENABLED, true);
$serializer->setOption(XML_SERIALIZER_OPTION_XML_ENCODING, 'ISO-8859-1');
$serializer->setOption(XML_SERIALIZER_OPTION_INDENT, '    ');
$serializer->setOption(XML_SERIALIZER_OPTION_ROOT_NAME, 'artist-info');
$serializer->setOption(XML_SERIALIZER_OPTION_SCALAR_AS_ATTRIBUTES,
                       array(
                         'artist' => array('email')
                           )
                       );
$serializer->setOption(XML_SERIALIZER_OPTION_DEFAULT_TAG, 'item');

// tworzymy dokument XML 
$serializer->serialize($data);

// pobieramy dokument
echo $serializer->getSerializedData();

?>