<?php
require_once 'XML/Parser.php';

/**
 * Klasa odczytujca pliki konfiguracyjne XML 
 */
class ConfigReader
{
   /**
    * wybrane rodowisko
    */
    private $environment;

   /**
    * sekcje, ktre zostay ju rozpatrzone
    */
    private $sections = array();

   /**
    * tymczasowe przechowywanie danych w trakcie analizy
    */
    private $currentSection = null;
    private $currentData = null;

   /**
    * Tworzymy nowy analizator ConfigReader
    *
    * @param acuch z wykorzystywanym rodowiskiem
    */
    public function __construct($environment = 'online')
    {
       $this->environment = $environment;
    }

  /**
 * zajmujemy si znacznikami otwierajcymi
 *
 * @param resource parser resource
 * @param string tag name
 * @param array attributes
 */
    
    public function startHandler($parser, $name, $attribs)
    {
        switch ($name) {
        	case 'section':
                // sprawdzamy, czy zostao okrelone waciwe rodowisko 
        		if (!isset($attribs['environment'])
        		    || $attribs['environment'] == $this->environment) {
        		        
                    // zapisujemy nazw sekcji
        			$this->currentSection = $attribs['name'];
                    // tworzymy pust tablic dla tej sekcji       			
        			$this->sections[$this->currentSection] = array();
        		}
        		break;
            case 'configuration':
                break;
            default:
                $this->currentData = '';
                break;
        }
    }

   /**
   * zajmujemy si danymi znakowymi
   *
   * @param zasb parsera
   * @param acuch z danymi znakowymi
   */
  
    public function cDataHandler($parser, $cData)
    {
        if (trim($cData) === '') {
            return;
        }
        $this->currentData .= $cData;
    }

/**
 * zajmujemy si znacznikami zamykajcymi
 *
 * @param resource parser resource
 * @param string tag name
 * @param array attributes
 */
 public function startHandler($parser, $name, $attribs)
 {
   switch ($name) {
      case 'configuration':
         break;
      case 'section':
         // sprawdzamy, czy zostao okrelone waciwe rodowisko 
            if (!isset($attribs['environment'])
                  || $attribs['environment'] == $this->environment) {
               // zapisujemy nazw sekcji
                   $this->currentSection = $attribs['name'];
               // tworzymy pust tablic dla tej sekcji
                   $this->sections[$this->currentSection] = array();
           }
              break;
      default:
         $this->currentData = '';
            break;
   }
} 

/**
 * Pobieramy opcj konfiguracyjn
 *
 * @param acuch z nazw sekcji
 * @param acuch z nazw opcji
 * @return opcja mieszanej konfiguracji lub fals, jeli nie zostaa okrelona
 */
 public function getConfigurationOption($section, $value)
{
   if (!isset($this->sections[$section])) {
      return false;
   }
   if (!isset($this->sections[$section][$value])) {
      return false;
   }
   return $this->sections[$section][$value];
 }
}

$config = new ConfigReader('online');
$parser = new XML_Parser();
$parser->folding = false;
$parser->setHandlerObj($config);
$parser->setInputFile('XML_Parser-001.xml');
$parser->parse();

printf("Folder buforowania : %s\n", $config->getConfigurationOption('paths', 'cache'));
printf("Poczenie z baz danych : %s\n", $config->getConfigurationOption('db', 'dsn'));

?>